#!/usr/local/bin/perl
# 
# $Header: getWebModuleMappings.pl 23-jul-2006.15:26:27 jsmoler Exp $
#
# getWebModuleMappings.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      getWebModuleMappings.pl - OC4J ECM integration: get web module mappings
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of web module
#      mappings for an OC4J instance. Includes the name and root URL of each
#      web module.
#
#      Implements the WebModuleURLs metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name> <version category>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/27/06 - use new output functions 
#    jsmoler     03/06/06 - use simpleXPath module 
#    jsmoler     12/23/05 - support system app for 10.1.3 
#    echolank    12/08/05 - strip out common web module processing 
#    jsmoler     08/22/05 - filter out extra apps
#    jsmoler     10/20/04 - boolean as integer 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/26/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];
my $versionCategory = $ARGV[2];

# Metric: WebModuleURLs
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # module name
    { 'type' => 'string', 'key' => 1 }, # application name
    { 'type' => 'string', 'key' => 1 }, # URL
    { 'type' => 'number' },             # load on startup
);

my @webModuleMappings = listOC4JWebModuleMappings($instanceName, $versionCategory);

for my $resultRef (@webModuleMappings)
{
    my $loadOnStartup = (ensuredef($$resultRef{'load-on-startup'}) eq 'true') ? 1 : 0;
    printMetricResult(
        $$resultRef{'name'},
        $$resultRef{'application'},
        $$resultRef{'root'},
        $loadOnStartup,
    );
}
