#!/usr/local/bin/perl
# 
# $Header: getWebModuleRoutingFlags.pl 07-mar-2006.12:48:32 jsmoler Exp $
#
# getWebModuleRoutingFlags.pl
# 
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      getWebModuleRoutingFlags.pl - get the "ohs-routing" flag
#      and the root context for every web module deployed to the OC4J.
#
#    DESCRIPTION
#      Command-line utility called by the agent to retrieve 
#      routing information for the web modules deployed to the OC4J.  This
#      information is defined in *-web-site.xml.
#
#      Command-line arguments: <oracle home> <oc4j instance name> <version category>
#
#      Outputs the root context and the value of ohs-routing for each web module.
#      Output format is:
#        em_result={module-name}|{app-name}|{root-context}|{ohs-routing}
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     03/06/06 - use simpleXPath 
#    jsmoler     12/23/05 - support system app for 10.1.3 
#    echolank    12/07/05 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];
my $versionCategory = $ARGV[2];

my @webModuleMappings = listOC4JWebModuleMappings($instanceName, $versionCategory);

for my $resultRef (@webModuleMappings)
{
    my $ohsRouting = (ensuredef($$resultRef{'ohs-routing'}) eq 'false') ? 0 : 1;
    printResult(
        $$resultRef{'name'},        'string',
        $$resultRef{'application'}, 'string',
        $$resultRef{'root'},        'string',
        $ohsRouting,                'number'
    );
}
