#!/usr/local/bin/perl
# 
# $Header: getCipherSuites.pl 17-apr-2008.17:23:52 jsmoler Exp $
#
# getCipherSuites.pl
# 
# Copyright (c) 2005, 2008, Oracle. All rights reserved.  
#
#    NAME
#      getCipherSuites.pl - Get OHS cipher suites.
#
#    DESCRIPTION
#      Implements the CipherSuites metric defined in oracle_apache.xml.
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     04/17/08 - convert all directive names to lower case
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     06/26/06 - use new output functions 
#    jsmoler     11/02/05 - rearrange perl 
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     03/11/05 - jsmoler_ecm_050228
#    jsmoler     02/28/05 - Creation
# 

use strict;
use ias::ohs::confFileParser;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

# Metric: CipherSuites
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # virtual host
    { 'type' => 'string(2000)' },       # cipher suite
);

my $hash = parseApacheConf();
my @vhosts = getApacheVHosts($hash);

for my $vhost (@vhosts)
{
    my $addr = $$vhost{'address'};
    my $props = $$vhost{'properties'};
    if ($props)
    {
        my $ssl = peek($$props{'SSLEngine'});
        if (defined($ssl) && ($ssl eq 'on'))
        {
            my $cipherSuite = peek($$props{'SSLCipherSuite'});
            printMetricResult($addr, $cipherSuite);
        }
    }
}
