#!/usr/local/bin/perl
# 
# $Header: getPerformanceRelated.pl 17-apr-2008.17:23:52 jsmoler Exp $
#
# getPerformanceRelated.pl
# 
# Copyright (c) 2004, 2008, Oracle. All rights reserved.  
#
#    NAME
#      getPerformanceRelated.pl - Apache ECM integration: get performance
#                                        related configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve performance-related
#      configuration information for Apache.
#
#      Implements the PerformanceRelated metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     12/21/07 - convert all directive names to lower case (bug
#                           6319688)
#    vaudinar    08/16/07 - OHS 2.0 10204 changes
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     11/02/05 - rearrange perl 
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     01/28/05 - apache -> Apache
#    jsmoler     12/02/04 - fix typo 
#    jsmoler     10/25/04 - remove defaults 
#    jsmoler     10/07/04 - add defaults
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::ohs::confFileParser;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $hash = parseApacheConf();

my $platform = getPlatform();

my $maxClients;
my $maxSpareServers;
my $minSpareServers;

if ($platform eq 'windows')
{
    $maxClients = peek($$hash{'ThreadsPerChild'});
}
else # unix
{
    $maxClients = peek($$hash{'MaxClients'});
    $maxSpareServers = peek($$hash{'MaxSpareServers'});
    $minSpareServers = peek($$hash{'MinSpareServers'});
}

printResult(
    $maxClients,                             'number',
    peek($$hash{'MaxRequestsPerChild'}),     'number',
    $maxSpareServers,                        'number',
    $minSpareServers,                        'number',
    peek($$hash{'StartServers'}),            'number',
    peek($$hash{'TimeOut'}),                 'number',
    peek($$hash{'ListenBackLog'}),           'number',
    peek($$hash{'KeepAlive'}),               'string',
    peek($$hash{'MaxKeepAliveRequests'}),    'number',
    peek($$hash{'KeepAliveTimeout'}),        'number',
    peek($$hash{'SSLSessionCacheTimeout'}),  'number',
    peek($$hash{'HostnameLookups'}),         'string',
    peek($$hash{'LogLevel'}),                'string',
    peek($$hash{'Oc4jSelectMethod'}),        'string',
    peek($$hash{'Oc4jCacheSize'}),           'number',
);
