#!/usr/local/bin/perl
# 
# $Header: getVirtualHosts.pl 17-apr-2008.17:23:52 jsmoler Exp $
#
# getVirtualHosts.pl
# 
# Copyright (c) 2004, 2008, Oracle. All rights reserved.  
#
#    NAME
#      getVirtualHosts.pl - Apache ECM integration: get virtual hosts
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve Apache configuration
#      information for virtual hosts. For each virtual host directive in httpd.conf,
#      outputs the ip and port for the virtual host, and the server name and type
#      for the associated host.
#
#      Implements the VirtualHosts metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     04/17/08 - convert all directive names to lower case
#    jsmoler     06/26/06 - use new output functions,
#                           change server type column to string to match metric
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     11/02/05 - rearrange perl 
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     03/03/05 - use vhost utility
#    jsmoler     01/28/05 - apache -> Apache
#    jsmoler     12/15/04 - change space to empty string 
#    jsmoler     10/05/04 - 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/19/04 - Creation
# 

use strict;
use ias::ohs::confFileParser;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

# Metric: VirtualHosts
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # IP
    { 'type' => 'number', 'key' => 1 }, # port
    { 'type' => 'string', 'key' => 1 }, # server name
    { 'type' => 'string', 'key' => 1 }, # server type
);

my $hash = parseApacheConf();
my @vhosts = getApacheVHosts($hash);

for my $vhost (@vhosts)
{
    my $addr = $$vhost{'address'};
    my $ip = $$vhost{'ip'};
    my $port = $$vhost{'port'};
    my $serverName;
    my $serverType;
    my $props = $$vhost{'properties'};
    if ($props)
    {
        $serverName = peek($$props{'ServerName'});
        
        if ($ip eq '_default_')
        {
            # _default_ isn't really an IP, so clear the IP
            $ip = '';
            $serverType = 'default';
        }
        else
        {
            my $nameVHost = $$hash{'NameVirtualHost'};
            if ($nameVHost && contains($addr, @{$nameVHost}))
            {
                $serverType = 'name';
            }
            else
            {
                $serverType = 'ip';
            }
        }
    }
    
    printMetricResult(
        $ip,
        $port,
        $serverName,
        $serverType,
    );
}
