#!/usr/local/bin/perl
# 
# $Header: WebCache_getClusterInfo.pl 28-jan-2005.12:52:14 jsmoler Exp $
#
# WebCache_getCaches.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      WebCache_getCaches.pl - WebCache ECM integration: list cluster members
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of names
#      of caches that are peers of the cache for the machine.
#
#      Implements the Caches metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     01/26/05 - check for singleton cluster
#    jsmoler     11/16/04 - jsmoler_ecm_041112
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/27/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my @caches = simpleXPathQuery("$oracleHome/webcache/webcache.xml",
                              'CALYPSO/CACHE');
if (@caches > 1)
{
    my $result = (simpleXPathQuery("$oracleHome/webcache/webcache.xml", 'CALYPSO/GENERAL/CLUSTER'))[0];
    printResult(
        $$result{'NAME'}, 'string',
    );
}
