#!/usr/local/bin/perl
# 
# $Header: getHostMappings.pl 23-jul-2006.15:26:27 jsmoler Exp $
#
# getHostMappings.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      getHostMappings.pl - WebCache ECM integration: get host mappings
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of mappings from
#      site to host.
#
#      Implements the SiteMappings metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/26/06 - use new output functions 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/27/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

# Metric: SiteMappings
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # site name
    { 'type' => 'string', 'key' => 1 }, # site port
    { 'type' => 'string', 'key' => 1 }, # site URL
    { 'type' => 'string', 'key' => 1 }, # host name
    { 'type' => 'number', 'key' => 1 }, # host port
);

my $xmlFile = "$oracleHome/webcache/webcache.xml";
my @mappings = simpleXPathQuery($xmlFile,
                                'CALYPSO/GENERAL/VIRTUALHOSTMAP');

for my $mapping (@mappings)
{
    my $siteName = ensuredef($$mapping{'NAME'});
    my $sitePort = ensuredef($$mapping{'PORT'});
    my $siteURL = ensureSlash($$mapping{'URL'});

    my @hostrefs = simpleXPathQuery($xmlFile,
                                    'CALYPSO/GENERAL/VIRTUALHOSTMAP[@NAME="' . $siteName . '"][@PORT="' . $sitePort . '"]/HOSTREF');
    for my $hostref (@hostrefs)
    {
        my $hostID = $$hostref{'HOSTID'};
        
        my $host = (simpleXPathQuery($xmlFile,
                                     'CALYPSO/GENERAL/HOST[@ID="' . $hostID . '"]'))[0];
        
        printMetricResult(
            $siteName,
            $sitePort,
            $siteURL,
            $$host{'NAME'},
            $$host{'PORT'},
        );
    }
}
