#!/usr/local/bin/perl
# 
# $Header: getListenPorts.pl 23-jul-2006.15:26:28 jsmoler Exp $
#
# getListenPorts.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      getListenPorts.pl - WebCache ECM integration: get listening ports
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of listening
#      ports.
#
#      Implements the ListenPorts metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/26/06 - use new output functions 
#    jsmoler     10/07/04 - change SSL mode to protocol
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/20/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $hostName = $ARGV[1];

# Metric: ListenPorts
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # IP
    { 'type' => 'number', 'key' => 1 }, # port
    { 'type' => 'string' },             # protocol
);

my $cacheName = getMyCache($hostName);
my $xmlFile = "$oracleHome/webcache/webcache.xml";

my @results = simpleXPathQuery($xmlFile,
                               'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/MULTIPORT/LISTEN[@PORTTYPE="NORM"]');

for my $result (@results)
{
    my $ip = getListenIP($$result{'IPADDR'});
    my $protocol = getListenProtocol($$result{'SSLENABLED'});
    printMetricResult(
        $ip,
        $$result{'PORT'},
        $protocol,
    );
}
