#!/usr/local/bin/perl
# 
# $Header: getOriginServers.pl 23-jul-2006.15:26:28 jsmoler Exp $
#
# getOriginServers.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      getOriginServers.pl - WebCache ECM integration: get origin servers
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of origin servers.
#
#      Implements the OriginServers metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/26/06 - use new output functions 
#    jsmoler     01/10/05 - use getListenProtocol 
#    jsmoler     12/23/04 - jsmoler_ecm_041213
#    jsmoler     12/16/04 - make protocol lowercase 
#    jsmoler     10/14/04 - jsmoler_ecm_041013a
#    jsmoler     10/07/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

# Metric: OriginServers
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # server name
    { 'type' => 'number', 'key' => 1 }, # server port
    { 'type' => 'string' },             # server protocol
    { 'type' => 'number' },             # server capacity
);

my @hosts = simpleXPathQuery("$oracleHome/webcache/webcache.xml",
                             'CALYPSO/GENERAL/HOST');

for my $host (@hosts)
{
    my $protocol = getListenProtocol($$host{'SSLENABLED'});
    printMetricResult(
        $$host{'NAME'},
        $$host{'PORT'},
        $protocol,
        $$host{'LOADLIMIT'},
    );
}
