#!/usr/local/bin/perl
# 
# $Header: WebCache_getPerformanceRelated.pl 15-oct-2004.10:48:13 jsmoler Exp $
#
# WebCache_getPerformanceRelated.pl
# 
# Copyright (c) 2004, Oracle. All rights reserved.  
#
#    NAME
#      WebCache_getPerformanceRelated.pl - WebCache ECM integration: get performance-
#                                          related configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve performance-related
#      configuration information for a cache.
#
#      Implements the PerformanceRelated metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     10/15/04 - fix typo
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $hostName = $ARGV[1];

my $cacheName = getMyCache($hostName);
my $xmlFile = "$oracleHome/webcache/webcache.xml";

my $limits = (simpleXPathQuery($xmlFile,
                               'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/RESOURCELIMITS'))[0];

my $info = (simpleXPathQuery($xmlFile,
                             'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/CALYPSONETINFO'))[0];

printResult(
    $$limits{'MAXCACHESIZE_MB'},        'number',
    $$limits{'MAXINBOUNDCONNECTIONS'},  'number',
    $$info{'KEEPALIVE_TIMEOUT'},        'number',
    $$info{'OSRECV_TIMEOUT'},           'number',
);
