#!/usr/local/bin/perl
# 
# $Header: getSiteAliases.pl 23-jul-2006.15:26:28 jsmoler Exp $
#
# getSiteAliases.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      getSiteAliases.pl - WebCache ECM integration: get site aliases
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of site aliases.
#
#      Implements the SiteAliases metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/26/06 - use new output functions 
#    jsmoler     10/07/04 - 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/27/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

# Metric: SiteAliases
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # site name
    { 'type' => 'number', 'key' => 1 }, # site port
    { 'type' => 'string', 'key' => 1 }, # site URL
    { 'type' => 'string', 'key' => 1 }, # alias name
    { 'type' => 'number', 'key' => 1 }, # alias port
    { 'type' => 'string', 'key' => 1 }, # alias URL
);

my $xmlFile = "$oracleHome/webcache/webcache.xml";
my @sites = simpleXPathQuery($xmlFile,
                            'CALYPSO/GENERAL/SITE');

for my $site (@sites)
{
    my $siteName = ensuredef($$site{'NAME'});
    my $sitePort = ensuredef($$site{'PORT'});
    my $siteURL = ensureSlash($$site{'URL'});

    my @aliases = simpleXPathQuery($xmlFile,
                                   'CALYPSO/GENERAL/SITE[@NAME="' . $siteName . '"][@PORT="' . $sitePort . '"]/ALIAS');
    for my $alias (@aliases)
    {
        my $aliasURL = ensureSlash($$alias{'URL'});
        printMetricResult(
            $siteName,
            $sitePort,
            $siteURL,
            $$alias{'NAME'},
            $$alias{'PORT'},
            $aliasURL,
        );
    }
}
