#!/usr/local/bin/perl
# 
# $Header: getSpecialPorts.pl 23-jul-2006.15:26:28 jsmoler Exp $
#
# getSpecialPorts.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      getSpecialPorts.pl - WebCache ECM integration: get special ports
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve the values of the
#      administration, invalidation, and statistics ports.
#
#      Implements the OperationPorts metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/26/06 - use new output functions 
#    jsmoler     10/07/04 - change ssl mode to protocol
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/20/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $hostName = $ARGV[1];

# Metric: OperationPorts
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # type
    { 'type' => 'string' },             # IP
    { 'type' => 'number' },             # port
    { 'type' => 'string' },             # protocol
);

my $cacheName = getMyCache($hostName);
my $xmlFile = "$oracleHome/webcache/webcache.xml";

my @results = simpleXPathQuery($xmlFile,
                               'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/MULTIPORT/LISTEN');

for my $result (@results)
{
    my $portType = $$result{'PORTTYPE'};
    if ($portType ne 'NORM')
    {
        my $ip = getListenIP($$result{'IPADDR'});
        my $protocol = getListenProtocol($$result{'SSLENABLED'});
        printMetricResult(
            $portType,
            $ip,
            $$result{'PORT'},
            $protocol,
        );
    }
}
