#!/usr/local/bin/perl
# 
# $Header: WebCache_listConfigFiles.pl 03-aug-2005.08:25:59 jsmoler Exp $
#
# WebCache_listConfigFiles.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      WebCache_listConfigFiles.pl - WebCache ECM integration: list configuration files
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for WebCache. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <for upload flag> <target name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     08/03/05 - collapse statFiles and restatFiles 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/19/04 - Creation
# 

use strict;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $forUploadStr = $ARGV[1];
my $forUpload = $forUploadStr eq 'true';
my $targetName = $ARGV[2];

statFiles(
    $forUpload,
    $targetName,
    
    'webcache/webcache.xml',
    'webcache/internal.xml',
);
