package ias::Apache_JavaConfParser;

use strict;
use Exporter 'import';
use File::Spec;
use Data::Dumper;
use File::Spec::Functions;
use IPC::Open3;
use IO::Handle;

our @EXPORT = qw(
    getConfFileProperties
    parsePropertyValues    
);


sub getConfFileProperties {
    my $className = $_[0]; 
    my $confFileName = $_[1];
    
    my $userstring =  <STDIN>;
    my $passwordstring = <STDIN>;
    my @usertokens = split("UserName=",$userstring);
    my $username = $usertokens[1];
    my @passwordtokens = split("password=",$passwordstring);
    my $password = $passwordtokens[1];

    my $agentHome = $ENV{ORACLE_HOME};
    my $AGENT_PLUGIN_ROOT = $ENV{'PLUGIN_ROOT'};
    my $java = catfile($agentHome, 'jdk', 'bin', 'java');
    my $emdjavajar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'emd_java.jar');
    my $wljmxclientjar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'wljmxclient.jar');
    my $cpsep = ":";
    my $agentStateDir = $ENV{EMSTATE};
    my $oraHome = $ENV{EMDROOT};
    my $agentTrust = catfile($agentStateDir, "sysman", "config", "montrust", "AgentTrust.jks");
    my $trustStoreProps = "-Dssl.debug=false -Djavax.net.ssl.trustStore=$agentTrust -Dweblogic.security.TrustKeyStore=CustomTrust -Dweblogic.security.CustomTrustKeyStoreFileName=$agentTrust -Dweblogic.security.SSL.enforceConstraints=off -Dweblogic.security.SSL.ignoreHostnameVerification=true";

    my $wlthint3client = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib','wlthint3client.jar');

    if(&IsWindows() ) {
        $cpsep = ";";
    }

    my $classpath = $emdjavajar . $cpsep . $wlthint3client . $cpsep;
    #my $className = 'oracle.sysman.emas.model.ohs.ConfigFileParser';
    my $command = $java . ' ' . $trustStoreProps . ' -classpath ' . $classpath . ' ' . $className . ' ' . $confFileName ;

    local (*HANDLE_IN, *HANDLE_OUT);
    my $pid =open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_OUT, $command);
    print HANDLE_IN "UserName=$username";
    print HANDLE_IN "password=$password";

    my $propValuesStr = <HANDLE_OUT>;

    close(HANDLE_IN);
    close(HANDLE_OUT);
    my @arVals = split(/&&/, $propValuesStr); 
    return @arVals;  
}

sub parsePropertyValues{
  my $inputStr = $_[0];
  $inputStr =~ s/=/,/g;
  my @arr= split(/,/, $inputStr);
  my $ctr = 0;
  my %hash=(); 
  my $arrLen = @arr;
  for ( $ctr; $ctr < $arrLen; ){
    my $key = $arr[$ctr];
    $ctr++;
    my $val = $arr[$ctr];
    $hash{$key} = $val; 
    $ctr++;
  }
  return %hash;
}

#parsePropertyValues ('ip=*,port=80,ServerType=ip,ServerAdmin=webmaster@host.example.com,DocumentRoot=/www/docs/host.example.com,ServerName=host.example.com,ErrorLog=logs/host.example.com-error_log,TransferLog=logs/host.example.com-access_log');

sub IsWindows {
    my $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" ){
        return 1;
    }else {
        return 0;
    }
}

