#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/Apache_getGeneral.pl /main/1 2009/10/12 04:39:06 djoly Exp $
#
# Apache_getGeneral.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Apache_getGeneral.pl - Apache ECM integration: get general configuration
#                             information
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve general configuration
#      information for Apache. Includes the document root and default port.
#
#      Implements the General metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     04/23/08 - Backport jsmoler_bug-6319688 from main
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5224028 from main
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     01/28/05 - apache -> Apache
#    jsmoler     12/16/04 - make protocol lowercase 
#    jsmoler     12/14/04 - get protocol, server name 
#    jsmoler     10/25/04 - remove defaults 
#    jsmoler     10/18/04 - use path type 
#    jsmoler     10/07/04 - add default values 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::Apache_confFileParser;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

my $hash = parseApacheConf();

printResult(
    peek($$hash{'DocumentRoot'}),    'path',
    peek($$hash{'Port'}),            'number',
    peek($$hash{'ServerName'}),      'string',
);
