#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/Apache_getPerformanceRelated_jmx.pl /main/2 2011/11/09 05:07:49 smariswa Exp $
#
# Apache_getPerformanceRelated.pl
# 
# Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Apache_getPerformanceRelated.pl - Apache ECM integration: get performance
#                                        related configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve performance-related
#      configuration information for Apache.
#
#      Implements the PerformanceRelated metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    smariswa    10/20/11 - Add threadsperchild and serverlimit
#    jsmoler     04/23/08 - Backport jsmoler_bug-6319688 from main
#    jsmoler     12/21/07 - convert all directive names to lower case (bug
#                           6319688)
#    vaudinar    08/01/07 - bug 6313682 
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5224028 from main
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     01/28/05 - apache -> Apache
#    jsmoler     12/02/04 - fix typo 
#    jsmoler     10/25/04 - remove defaults 
#    jsmoler     10/07/04 - add defaults
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::AS11OHS_confFileParser;
use ias::asecm;

my $serviceURL = $ARGV[0]; # 'service:jmx:t3://stadj37:7001/jndi/weblogic.management.mbeanservers.domainruntime';
my $mbeanObjName =  $ARGV[1]; # 'oracle.as.management.mbeans.register:type=component,name=ohs1,instance=instance1';
my $hash = parseConfFile($serviceURL, $mbeanObjName);

printResult(
    peek($$hash{'MaxClients'}),  	     'number',
    peek($$hash{'MaxRequestsPerChild'}),     'number',
    peek($$hash{'MaxSpareServers'}), 	     'number',
    peek($$hash{'MinSpareServers'}),	     'number',
    peek($$hash{'StartServers'}),            'number',
    peek($$hash{'TimeOut'}),                 'number',
    peek($$hash{'ListenBackLog'}),           'number',
    peek($$hash{'KeepAlive'}),               'string',
    peek($$hash{'MaxKeepAliveRequests'}),    'number',
    peek($$hash{'KeepAliveTimeout'}),        'number',
    peek($$hash{'SSLSessionCacheTimeout'}),  'number',
    peek($$hash{'HostnameLookups'}),         'string',
    peek($$hash{'LogLevel'}),                'string',
    peek($$hash{'Oc4jSelectMethod'}),        'string',
    peek($$hash{'Oc4jCacheSize'}),           'number',
    peek($$hash{'ThreadsPerChild'}),         'number',
    peek($$hash{'ServerLimit'}),             'number',
);
