#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/Apache_getVirtualHosts_jmx.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# Apache_getVirtualHosts.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Apache_getVirtualHosts.pl - Apache ECM integration: get virtual hosts
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve Apache configuration
#      information for virtual hosts. For each virtual host directive in httpd.conf,
#      outputs the ip and port for the virtual host, and the server name and type
#      for the associated host.
#
#      Implements the VirtualHosts metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home> <port column type>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     07/31/08 - non-numeric ports (bug 7233413)
#    jsmoler     04/23/08 - Backport jsmoler_bug-6319688 from main
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5224028 from main
#    jsmoler     06/26/06 - use new output functions,
#                           change server type column to string to match metric
#    jsmoler     08/07/06 - Backport jsmoler_bug-5295826 from
#                           st_emasgc_10.2.0.1.0
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     03/03/05 - use vhost utility
#    jsmoler     01/28/05 - apache -> Apache
#    jsmoler     12/15/04 - change space to empty string 
#    jsmoler     10/05/04 - 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/19/04 - Creation
# 

use strict;
use ias::AS11OHS_confFileParser;
use ias::asecm;

#my $oracleHome = $ARGV[0];
#setOracleHome($oracleHome);
my $serviceURL = $ARGV[0];# 'service:jmx:t3://stadj37:7001/jndi/weblogic.management.mbeanservers.domainruntime';
my $mbeanObjName = $ARGV[1]; #'oracle.as.management.mbeans.register:type=component,name=ohs1,instance=instance1';
my $portType = $ARGV[2]; #"string";

# Metric: VirtualHosts
setMetricFormat(
    { 'type' => 'string',  'key' => 1 }, # IP
    { 'type' => $portType, 'key' => 1 }, # port
    { 'type' => 'string',  'key' => 1 }, # server name
    { 'type' => 'string',  'key' => 1 }, # server type
);

#my $hash = parseApacheConf();
my $hash = parseConfFile($serviceURL, $mbeanObjName);
my @vhosts = getApacheVHosts($hash);

for my $vhost (@vhosts)
{
    my $addr = $$vhost{'address'};
    my $ip = $$vhost{'ip'};
    my $port = $$vhost{'port'};
    my $serverName;
    my $serverType;
    my $props = $$vhost{'properties'};
    if ($props)
    {
        $serverName = peek($$props{'ServerName'});
        
        if ($ip eq '_default_')
        {
            # _default_ isn't really an IP, so clear the IP
            $ip = '';
            $serverType = 'default';
        }
        else
        {
            my $nameVHost = $$hash{'NameVirtualHost'};
            if ($nameVHost && contains($addr, @{$nameVHost}))
            {
                $serverType = 'name';
            }
            else
            {
                $serverType = 'ip';
            }
        }
    }
    
    # Avoid errors uploading a non-numeric port to a pre-10.2.0.5 OMS.
    # Note that the port cannot be NULL in the repository.
    if ($portType eq 'number' && $port !~ /^[0-9]+$/)
    {
        $port = -1;
    }
    
    printMetricResult(
        $ip,
        $port,
        $serverName,
        $serverType,
    );
}
