#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/IAS_getConsoleInfo.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# IAS_getConsoleInfo.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      IAS_getConsoleInfo.pl - IAS ECM integration: get console configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve console configuration
#      information for IAS. Includes the agent and console URLs.
#
#      Implements the ConsoleInfo metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home> <host name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     07/31/08 - get console port from opmn.xml for 10.1.3 (bug 7233413)
#    jsmoler     12/23/05 - handle case of no emd.properties file for 10.1.3 
#    jsmoler     12/10/04 - no error if xml file not found 
#    jsmoler     12/03/04 - change url to path 
#    jsmoler     12/02/04 - fail if xml file not found 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;
use ias::propertiesFileParser;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $hostName = $ARGV[1];
my $versionCategory = $ARGV[2];

my $emdProtocol;
my $emdHost;
my $emdPort;
my $emdPath;
my $emdPropsFile = "$oracleHome/sysman/config/emd.properties";
if (-e $emdPropsFile)
{
    my %hash = parsePropertiesFile($emdPropsFile);
    my $emdURL = $hash{'EMD_URL'};
    if ($emdURL =~ /^([^:]*):\/\/([^:\/]*):([0-9]*)\/(.*)/)
    {
        $emdProtocol = $1;
        $emdHost = $2;
        $emdPort = $3;
        $emdPath = $4;
    }
}

my $consoleProtocol;
my $consoleHost;
my $consolePort;
if ($versionCategory eq '1013plus')
{
    # For 10.1.3, get the console port and protocol from opmn.xml
    # Find the OC4J instance that hosts the ascontrol app
    my @instances = listOC4JInstances();
    my $ascontrolInstance;
    for my $instanceName (@instances)
    {
        my @apps = listOC4JDeployedApps($instanceName, $versionCategory);
        for my $appName (@apps)
        {
            if ($appName eq 'ascontrol')
            {
                $ascontrolInstance = $instanceName;
                last;
            }
        }
        if (defined($ascontrolInstance))
        {
            last;
        }
    }
    if (defined($ascontrolInstance))
    {
        # Look for http or https ports configured on the OC4J
        my @ports = simpleXPathQuery(
            "$oracleHome/opmn/conf/opmn.xml",
            'opmn//process-type[@module-id="OC4J"][@id="' . $ascontrolInstance . '"]/port'
        );
        for my $port (@ports)
        {
            if (($$port{'id'} eq 'http' || $$port{'id'} eq 'https') &&
                ($$port{'range'} =~ /^[0-9]+$/)) # Only report the port if it is not a range
            {
                $consoleProtocol = $$port{'id'};
                $consolePort = $$port{'range'};
                $consoleHost = $hostName;
                last;
            }
        }
    }
}
else
{
    # For pre-10.1.3, get the console port and protocol from emd-web-site.xml
    my $xmlFile = "$oracleHome/sysman/j2ee/config/emd-web-site.xml";
    if (-e $xmlFile)
    {
        my $webSite = (simpleXPathQuery($xmlFile, 'web-site'))[0];
        if (defined($$webSite{'protocol'}))
        {
            $consoleProtocol = $$webSite{'protocol'};
        }
        else
        {
            $consoleProtocol = 'http';
        }
        $consoleHost = $hostName;
        $consolePort = $$webSite{'port'};
    }
}

printResult(
    $emdProtocol,       'string',
    $emdHost,           'string',
    $emdPort,           'number',
    $emdPath,           'string',
    $consoleProtocol,   'string',
    $consoleHost,       'string',
    $consolePort,       'number',
);
