#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/OHS_getCipherSuites_jmx.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# OHS_getCipherSuites.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OHS_getCipherSuites.pl - Get OHS cipher suites
#
#    DESCRIPTION
#      Implements the CipherSuites metric defined in oracle_apache.xml.
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     04/23/08 - Backport jsmoler_bug-6319688 from main
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5224028 from main
#    jsmoler     06/26/06 - use new output functions 
#    jsmoler     08/07/06 - Backport jsmoler_bug-5295826 from
#                           st_emasgc_10.2.0.1.0
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     03/11/05 - jsmoler_ecm_050228
#    jsmoler     02/28/05 - Creation
# 

use strict;
use ias::AS11OHS_confFileParser;
use ias::asecm;

#my $oracleHome = $ARGV[0];
#setOracleHome($oracleHome);

# Metric: CipherSuites
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # virtual host
    { 'type' => 'string(2000)' },       # cipher suite
);

#my $hash = parseApacheConf();
my $serviceURL = $ARGV[0]; #  'service:jmx:t3://stadj37:7001/jndi/weblogic.management.mbeanservers.domainruntime';
my $mbeanObjName = $ARGV[1]; # 'oracle.as.management.mbeans.register:type=component,name=ohs1,instance=instance1';
my $hash = parseConfFile($serviceURL, $mbeanObjName);
my @vhosts = getApacheVHosts($hash);

for my $vhost (@vhosts)
{
    my $addr = $$vhost{'address'};
    my $props = $$vhost{'properties'};
    if ($props)
    {
        my $ssl = peek($$props{'SSLEngine'});
        if (defined($ssl) && ($ssl eq 'on'))
        {
            my $cipherSuite = peek($$props{'SSLCipherSuite'});
            printMetricResult($addr, $cipherSuite);
        }
    }
}
