#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/WebCache_getCaches.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# WebCache_getCaches.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getCaches.pl - WebCache ECM integration: list cluster members
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of names
#      of caches that are peers of the cache for the machine.
#
#      Implements the ClusterMembers metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5295826 from
#                           st_emasgc_10.2.0.1.0
#    jsmoler     06/26/06 - use new output functions 
#    jsmoler     01/26/05 - check for singleton cluster
#    jsmoler     11/12/04 - output host name and Oracle Home instead of cache name
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/27/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;
use Net::hostent;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

# Metric: ClusterMembers
setMetricFormat(
    { 'type' => 'raw-string', 'key' => 1 }, # host name
    { 'type' => 'raw-string', 'key' => 1 }, # oracle home
    { 'type' => 'number' },                 # capacity
);

my @caches = simpleXPathQuery("$oracleHome/webcache/webcache.xml",
                              'CALYPSO/CACHE');

if (@caches > 1)
{
    for my $cache (@caches)
    {    
        my $hostName = $$cache{'HOSTNAME'};
        my $hostEnt = gethostbyname($hostName);
        $hostName = $hostEnt->name;
        printMetricResult(
            $hostName,
            $$cache{'ORACLEHOME'},
            $$cache{'CAPACITY'},
        );
    }
}
