#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/WebCache_getCaches_jmx.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# WebCache_getCaches_jmx.pl
# 
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getCaches_jmx.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    skotha      08/19/09 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;
use Net::hostent;
use ias::webtierConfig;

my $xmlString = fetchConfigFile($ARGV[0], $ARGV[1], 'getFileContents', 'webcache.xml');

# Metric: ClusterMembers
setMetricFormat(
    { 'type' => 'raw-string', 'key' => 1 }, # host name
    { 'type' => 'raw-string', 'key' => 1 }, # oracle home
    { 'type' => 'number' },                 # capacity
);

my @caches = simpleXPathQuery($xmlString, 'CALYPSO/CACHE', 'string-type');

if (@caches > 1)
{
    for my $cache (@caches)
    {    
        my $hostName = $$cache{'HOSTNAME'};
        my $hostEnt = gethostbyname($hostName);
        $hostName = $hostEnt->name;
        printMetricResult(
            $hostName,
            $$cache{'ORACLEHOME'},
            $$cache{'CAPACITY'},
        );
    }
}
