#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/WebCache_getListenPorts_jmx.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# WebCache_getListenPorts_jmx.pl
# 
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getListenPorts_jmx.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    skotha      08/24/09 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;
use ias::webtierConfig;

my $hostName = $ARGV[2];

# Metric: ListenPorts
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # IP
    { 'type' => 'number', 'key' => 1 }, # port
    { 'type' => 'string' },             # protocol
);

my $oracleHome = $ARGV[3];
setOracleHome($oracleHome);

my $content = fetchConfigFile($ARGV[0], $ARGV[1], 'getFileContents', 'webcache.xml');
my $cacheName = getMyCache($hostName, $content, 'string-type');

my @results = simpleXPathQuery($content,
                               'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/MULTIPORT/LISTEN[@PORTTYPE="NORM"]', 'string-content');

for my $result (@results)
{
    my $ip = getListenIP($$result{'IPADDR'});
    my $protocol = getListenProtocol($$result{'SSLENABLED'});
    printMetricResult(
        $ip,
        $$result{'PORT'},
        $protocol,
    );
}
