#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/WebCache_getPerformanceRelated_jmx.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# WebCache_getPerformanceRelated.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getPerformanceRelated.pl - WebCache ECM integration: get performance-
#                                          related configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve performance-related
#      configuration information for a cache.
#
#      Implements the PerformanceRelated metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    skotha      08/23/09 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;
use ias::webtierConfig;

my $xmlString = fetchConfigFile($ARGV[0], $ARGV[1], 'getFileContents', 'webcache.xml');

my $hostName = $ARGV[3];
setOracleHome($ARGV[2]);

my $cacheName = getMyCache($hostName, $xmlString, 'string-type');

my $limits = (simpleXPathQuery($xmlString,
                               'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/RESOURCELIMITS', 'string-type'))[0];

my $info = (simpleXPathQuery($xmlString,
                             'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/CALYPSONETINFO', 'string-type'))[0];

printResult(
    $$limits{'MAXCACHESIZE_MB'},        'number',
    $$limits{'MAXINBOUNDCONNECTIONS'},  'number',
    $$info{'KEEPALIVE_TIMEOUT'},        'number',
    $$info{'OSRECV_TIMEOUT'},           'number',
);
