#!/usr/local/bin/perl
#
# getBpelClusterDetail.pl
#
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getBpelClusterDetail.pl - BPEL PM ECM integration
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for Apache. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_integrationbpm.xml.
#
#      Command-line arguments: <oracle home> 
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    kotkumar    07/27/07 - Updating for BPEL 10.1.2
#    rsaraswa    05/20/07 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $oracleHome = $ARGV[0];

my $xmlFile; 

if(-e  "$oracleHome/bpel/system/config/collaxa-config.xml")
{
	$xmlFile = "$oracleHome/bpel/system/config/collaxa-config.xml";
}else {	
	$xmlFile = "$oracleHome/integration/orabpel/system/config/collaxa-config.xml";	

}

my $enableCluster = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-server-descriptor//property[@id="enableCluster"]/value'))[0];
my $clusterName = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-server-descriptor//property[@id="clusterName"]/value'))[0];


my $mcast_port;
my $mcast_addr;
my $jgroupsfile;
if(-e  "$oracleHome/bpel/system/config/jgroups-protocol.xml")
{
	
	$jgroupsfile = "$oracleHome/bpel/system/config/jgroups-protocol.xml";
}else {	
	
	$jgroupsfile = "$oracleHome/integration/orabpel/system/config/jgroups-protocol.xml";
	

}

if(-e $jgroupsfile) {
my @udpTags = ias::simpleXPath::simpleXPathQuery($jgroupsfile, 'config/UDP');
   for my $udpTag (@udpTags)
   {
      $mcast_port = $$udpTag{'mcast_port'};
      $mcast_addr = $$udpTag{'mcast_addr'};
   } 
}

ias::asecm::printResult(
     $enableCluster,      'string',
     $clusterName,    'string',
     $mcast_port,   'string',
     $mcast_addr,   'string',
);




