#!/usr/local/bin/perl
# 
#
# getConfigFiles.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getConfigFiles.pl - Apache ECM integration: list configuration files
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for Apache. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_integrationbpm.xml.
#
#      Command-line arguments: <oracle home> <for upload flag> <target name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       kotkumar 07/27/07 - Updating for BPEL 10.1.2
#       rsaraswa 06/10/07 - 




use strict;
use ias::asecm;
use ias::bpel::confFileParser;

my $oracleHome = $ARGV[0];
ias::asecm::setOracleHome($oracleHome);
my $forUploadStr = $ARGV[1];
my $forUpload = $forUploadStr eq 'true';
my $targetName = $ARGV[2];


my $BPEL_DOMAIN_HOME;
if(-e  "$oracleHome/bpel/domains")
{
	
	$BPEL_DOMAIN_HOME = "$oracleHome/bpel/domains";
}else {	
	
	$BPEL_DOMAIN_HOME = "$oracleHome/integration/orabpel/domains"; 	

}
opendir(DIR,$BPEL_DOMAIN_HOME);
my @domains = readdir(DIR);
closedir(DIR);
for my $domain (@domains) 
{
	#opendir(DIR1,"$oracleHome/bpel/domains/$domain/config");
	#my @files = readdir(DIR1);
	#for my $confFile (@files)
#{
    #print "$confFile\n";
   ias::asecm::statFile("$BPEL_DOMAIN_HOME/$domain/config/domain.xml", $forUpload, $targetName);
   
#ias::asecm::statFile("/scratch/rsaraswa/soa_install_new/bpel/domains/default/tmp/.bpel_BPELProcess4_1.0_dc4a703c46a242f69d6cea305b2df3a3.tmp/BPELProcess4.bpel", $forUpload, $targetName);
#} #end files

} #end domains

my $BPEL_HOME;
if(-e  "$oracleHome/bpel")
{
	
	$BPEL_HOME = "$oracleHome/bpel";
}else {	
	
	$BPEL_HOME = "$oracleHome/integration/orabpel"; 	

}

if(-e "$BPEL_HOME/system/config/collaxa-config.xml") {
ias::asecm::statFile("$BPEL_HOME/system/config/collaxa-config.xml", $forUpload, $targetName);
}

if(-e "$BPEL_HOME/system/config/jgroups-protocol.xml") {
ias::asecm::statFile("$BPEL_HOME/system/config/jgroups-protocol.xml", $forUpload, $targetName);
}