#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/j2ee_application/Application.pl /main/1 2011/04/21 04:28:24 sasachde Exp $
#
# Application.pl
#
# Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Application.pl - Collects general J2EE application configuration
#
#    DESCRIPTION
#      Collects general J2EE application configuration.
#      Implements the Application metric defined in j2ee_application.xml.
#      Command-line arguments: <scripts dir> <domain home> <application name>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     10/27/08 - Creation
# 

use strict;
use ias::simpleXPath;

my ( $domainHome, $appName ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my $app = (ias::simpleXPath::queryForNodes($configFile,
    'domain/app-deployment[name="' . $appName . '"]'))[0];

print 'em_result='
      . (ias::simpleXPath::queryForText($app, 'app-deployment/source-path'))[0]
. '|' . (ias::simpleXPath::queryForText($app, 'app-deployment/deployment-order'))[0]
. '|' . (ias::simpleXPath::queryForText($app, 'app-deployment/module-type'))[0]
. "\n";
