#!/usr/local/bin/perl
#
# $Header: emas/sysman/admin/scripts/ias.10g/logRotation/logRotation.pl /main/3 2011/10/31 03:27:27 vaudinar Exp $
#	
# logRotation.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      logRotation.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    skotha      05/20/10 - NG Agent Uptake - Remove EMDROOT usages
#    vaudinar    06/26/06 - Creation
# 
use strict;
use File::Copy;
use File::Path;
use File::Basename;
use File::Spec;
use ias::asecm;
use ias::simpleXPath;
use Time::localtime;

my $platform = getPlatform();
my $perlexec = "perl";

my $args = $ARGV[0];
my $startComponent = 1;
my $errMsg;
my @logNames;
my $response;
my $result;
my $logsList;
my $retCode;
my $exitCode=1;
my @inputData =split('#', $args);

my $rotatedLogName;
my $oracleHome = trimwhitespace(@inputData[0]);
my $iasInstance = trimwhitespace(@inputData[1]);
my $target = trimwhitespace(@inputData[2]);
my $logRotationDir = trimwhitespace(@inputData[3]);
my $logList = trimwhitespace(@inputData[4]);
print "Oracle Home: $oracleHome \n";
print "Target Name: $target \n";

	if(!defined $logList) {
		print "No logs to rotate";
		exit 0;
	}

	if($logRotationDir =~ m/NOT_SPECIFIED/) {
      		print "Log Rotation directory: Not Specified \n";	
	}
	else {
      		print "Log Rotation directory: $logRotationDir \n";
	}	
        
 
	if($iasInstance ne "") {
 	
	 	my @logs =  split(';', $logList);
		
		print "Logs: ";
	        for my $log (@logs) {
			print "$log \n";
			print "      ";
		}
		
		$response = StopIASComponent($target);

		if($retCode == 0) {

			if ($response =~ m/SUCCESS/) {
				print "\n\"$target\" has been stopped";	
				print "\n";
			}
			elsif ($response =~ m/The component was not stopped as it is already down/) {
				$startComponent = 0;
				print $response;
				print "\n";
			}	
			
  			for my $log (@logs) {
				print "\n";
				print "Log Name: $log \n";
	
				$result = archive($log);
				
				if ($result == 1) {
					print "\"$log\" was rotated successfully\n";
					print "Rotated log file name: $rotatedLogName \n";
					$exitCode=0;
				}
				elsif ($result eq "LFDNE") {
					print"Failed to rotate \"$log\"\. $log doesn't exist \n";  
				}
				else {
					print "Failed to rotate \"$log\"\. $result \n"; 
				}
		          }
		
			if($startComponent == 1) {		          
  		        	$response = StartIASComponent($target);
       				if($retCode == 0) { 
				
					print "\n\"$target\" has been started";	
					print "\n";
				}
				else {
					print "$response \n";	
				}
  	        	}	
	       } 
	       else {
	       	     print "Unable to stop $target. $response \n";		
	       }
	}

exit $exitCode;


sub archive {
 my $Hour;
 my $Month;
 my $Second;
 my $Minute;
 my $Day;
 my $Year;
 my $Sec;
 my $fileName;
 my $logName =$_[0];

 if( ! -e $logName) {
    	return "LFDNE";
 }
 my $time_stamp = localtime(time) ;
 $Year = $time_stamp->year +1900;
 $Month = $time_stamp->mon + 1;
 $Month = prefixWithZero($Month);
 $Day = prefixWithZero($time_stamp->mday);
 $Hour = prefixWithZero($time_stamp->hour);
 $Minute = prefixWithZero($time_stamp->min);
 $Sec = prefixWithZero($time_stamp->sec);

 my $suffix = $Year . $Month . $Day . "_" . $Hour . $Minute . $Sec;
 my $newFile = $logName;
 my $oldLogName;
 my $defaultLocation;
 my $endIndex;

 $fileName = basename($logName);
 $defaultLocation = dirname($logName);
 
 $rotatedLogName = $fileName.".".$suffix;
 
     if ($logRotationDir ne  "NOT_SPECIFIED") {
	
 	my $logDestinationDir;
	my $tempPath;
	my $idx = -1;
	if ( $platform eq "windows") {
		$defaultLocation =~ s/\//\\/g;
	}	
	
	$idx = index($defaultLocation, $oracleHome);
	
	if($idx == 0){
		$endIndex = length($oracleHome);
	 	$tempPath= substr($defaultLocation,$endIndex);
	}
	else {
		if( $defaultLocation =~ m/^\// ) { #for Linux
			$tempPath= substr($defaultLocation,1);
		}
		elsif( $defaultLocation =~ m/\:/) { #for Windows
			$idx = index($defaultLocation,":")+1;	
			$tempPath = substr($defaultLocation,$idx);
		}
		else {  #for Linux
			$tempPath= substr($defaultLocation,0);	
		}
	}

	my $instanceName = $iasInstance;
	my $startIndex = rindex($iasInstance, "/");
	 if($startIndex != -1) {
		$instanceName = substr($iasInstance,$startIndex + 1);
 	}
	$logDestinationDir = File::Spec->catfile($logRotationDir, $instanceName, $tempPath);
	print "Rotate to $logDestinationDir";
	print "\n";
	
  	    if( ! -e $logDestinationDir) {
  		 print "$logDestinationDir directory doesn't exist. \n";

    	 	eval { mkpath($logDestinationDir,1) };
	    	if ($@) {
	      		print "Couldn't create $logDestinationDir: $@ \n";
      			print "Using the default location $defaultLocation\n";
    	    	}
    	    	else {
			$fileName =  $fileName . "." .$suffix;    	    	
			$oldLogName = File::Spec->catfile($logDestinationDir, $fileName);
    	    	}
      	    }	
      	    elsif(! -d $logRotationDir){
  	 	print "$logRotationDir is not a direcory. \n"; 
  	 	print "Using default location  $defaultLocation\n";
	    }
	    else
      	    {		
		$fileName =  $fileName . "." .$suffix;    	    	
		$oldLogName = File::Spec->catfile($logDestinationDir, $fileName);
      	    }
      	
     }	
     else {
  	 print "Rotation directory is not specified. \nUsing default location  $defaultLocation\n";
     }

     if(!defined $oldLogName) {
	$oldLogName = $logName . "." .$suffix;
     }
     my $rc;
     $rc = move($logName,$oldLogName);
     
     if($rc ==1) {
	 my $rc1 = open(FILEHANDLE, ">$newFile");
 	 close(FILEHANDLE);
      }
      else {
 	$rc = $!;		
      }
      return $rc;
}

sub prefixWithZero {
     my $str = $_[0];
     if($str < 10) {
     		$str = "0" . $str; 
     }
     return $str;
}     

sub StartIASComponent 
{
	
     my $iasComponent = shift;
     my $cmd = "$perlexec  $ENV{'PLUGIN_ROOT'}/scripts/em_optic.pl $oracleHome en_US start ias-instance=$iasInstance#process-type=$iasComponent";
     my @output = `$cmd`;
     my $out = "@output";
     my $resp = ParseStartStop($out);
     return $resp;
}

sub StopIASComponent 
{
     my $iasComponent = shift;
     my $cmd = "$perlexec  $ENV{'PLUGIN_ROOT'}/scripts//em_optic.pl $oracleHome en_US stop ias-instance=$iasInstance#process-type=$iasComponent";
     my @output = `$cmd`;
     my $out = "@output";
     my $resp = ParseStartStop($out);
     return $resp;
}
sub ParseStartStop
{
     my $output = shift;
     $output  =~ /<ExitCode>(\d+)<\/ExitCode>/;
     $retCode = $1;
     $output  =~ /<ResponseMessage>(.+)<\/ResponseMessage>/;
     return $1;
}

sub trimwhitespace($)
{
     my $string = shift;
     $string =~ s/^\s+//;
     $string =~ s/\s+$//;
     return $string;
}
    
