#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oc4j/OC4J_listAdapterConfigFiles.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# OC4J_listAdapterConfigFiles.pl
# 
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OC4J_listAdapterConfigFiles.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rsaraswa    06/03/09 - Creation
#


use strict;
use ias::asecm;
use File::Find;
use File::stat;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $forUploadStr = $ARGV[1];
my $forUpload = $forUploadStr eq 'true';
my $targetName = $ARGV[2];
my $oc4jName = $ARGV[3];


my @subDirs = ( 'connectors');#, 'applications', 'application-deployments' );
my $fileName = "oc4j-ra.xml";
for my $subDir (@subDirs)
{
    find({
        wanted => sub
        {
                if ($_ =~ /^$fileName$/)
                {
                    statFile($File::Find::name, $forUpload, $targetName, $oc4jName);
                }
        },
        follow => (getPlatform() eq 'unix'), # follow links
        follow_skip => 2 # if the same file is visited twice, skip it the second time
    },
    "$oracleHome/j2ee/$oc4jName/$subDir");
} 
