#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oc4j/getJVMInfo.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# getJVMInfo.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getJVMInfo.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     07/18/07 - Backport jsmoler_bug-5736476_test_070712 from
#                           st_emasgc_10.2.0.1.0
#    jsmoler     07/12/07 - support OPMN variables
#    jsmoler     08/02/06 - use ias::simpleXPath
#    sparmesw    12/19/05 - Creation
# 

use strict;
require "emd_common.pl";
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
my $instanceName = $ARGV[1];

setOracleHome($oracleHome);
my  $jvmVersion = getJVMVersion($oracleHome,$instanceName);
my $isJVMMBeansEnabled = isJVMMBeansEnabledOn1013PlusOC4J($oracleHome, $instanceName);

printResult(
    $jvmVersion, 'string',
    $isJVMMBeansEnabled, 'string',
);
exit 0;

sub getJVMVersion
{
  my ($oracleHome,$instanceName) = @_;
  my $jdkLocation = getJDKLocationForOC4J($oracleHome,$instanceName);
  my $jdkVersion = "1.5.0_05";

#
# Check by doing java -version and extract version of jvm
#
  my $verOut = `$jdkLocation -version 2>&1`;
  if ($? != 0)
  { 
    EMD_PERL_DEBUG("Failed to run $jdkLocation -version command\n");
  }
  else 
  {
    EMD_PERL_DEBUG("Output of $jdkLocation -version command is $verOut\n");
    my @array = split (/\r/,$verOut);
    my $verString;
    VERLINE:foreach $verString (@array) {
      if (index($verString,"version") >= 0)
      {
         $verString =~ s/^\s+//;   # remove any leading space
         chomp($verString);
         $verString = substr($verString,index($verString,"\""));
         my $firstIndex = index($verString,"\"");
         my $secIndex = index($verString,"\"",$firstIndex+1);
         $verString = substr($verString, $firstIndex+1, $secIndex-1);
         $jdkVersion = $verString;
         my $indexOfUnderscore = index($verString,"_");
         if ($indexOfUnderscore > 0)
         {
            $jdkVersion = substr($verString,0,$indexOfUnderscore);
         }
         EMD_PERL_DEBUG ("Setting jdk version to $jdkVersion\n");
         last VERLINE;
      }
    }
  }
  return $jdkVersion;
}

sub getJDKLocationForOC4J
{
   my ($iasHome, $oc4jInstanceDisplayName) = @_;
   my $isEnabled = "0";
   EMD_PERL_DEBUG("JVM location for $oc4jInstanceDisplayName\n");

   my %moduleData = ias::asecm::getOpmnModuleData({
      'module' => 'OC4J',
      'process-type' => $oc4jInstanceDisplayName
   });
   my $javaLocation = $moduleData{'start-parameters'}{'java-bin'};
   if (!defined($javaLocation))
   {
      $javaLocation = "$iasHome/jdk/bin/java";
   }
   EMD_PERL_DEBUG("Returning java loc as $javaLocation\n");
   return $javaLocation;
}

sub isJVMMBeansEnabledOn1013PlusOC4J
{
   my ($iasHome, $oc4jInstanceDisplayName) = @_;
   my $isEnabled = "0";
   EMD_PERL_DEBUG("is JVMs enabled for $oc4jInstanceDisplayName\n");

   my %moduleData = ias::asecm::getOpmnModuleData({
      'module' => 'OC4J',
      'process-type' => $oc4jInstanceDisplayName
   });
   my $javaStartOptions = $moduleData{'start-parameters'}{'java-options'};
   if (defined($javaStartOptions) && index($javaStartOptions,"-Dcom.sun.management.jmxremote") >= 0)
   {
      $isEnabled = "1";
      EMD_PERL_DEBUG("JVM Mbeans enabled for $oc4jInstanceDisplayName\n");
   } else {
      EMD_PERL_DEBUG("NO JVM Mbeans enabled for $oc4jInstanceDisplayName\n");
   }
   return $isEnabled;
}
