#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oc4j/getManagedDataSources.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# getManagedDataSources.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getManagedDataSources.pl - Get OC4J managed data sources.
#
#    DESCRIPTION
#      Implements the OC4J ManagedDataSources metric.
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5295826 from
#                           st_emasgc_10.2.0.1.0
#    jsmoler     06/27/06 - use new output functions 
#    jsmoler     11/29/05 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];

# Metric: ManagedDataSources
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # name
    { 'type' => 'string', 'key' => 1 }, # application
    { 'type' => 'string', 'key' => 1 }, # location
    { 'type' => 'string' },             # connection pool
);

my @dataSourceFiles = listOC4JDataSourceFiles($instanceName);
for my $appInfo (@dataSourceFiles)
{
    my @dataSources = simpleXPathQuery(
        $$appInfo{'file'},
        'data-sources/managed-data-source'
    );
    my %jndiLocHash;
    for my $dataSource (@dataSources)
    {
        $jndiLocHash{$$dataSource{'jndi-name'}} = $dataSource;
    }
    for my $jndiLoc (keys %jndiLocHash)
    {
        my $dataSource = $jndiLocHash{$jndiLoc};
        printMetricResult(
            $$dataSource{'name'},
            $$appInfo{'application'},
            $$dataSource{'jndi-name'},
            $$dataSource{'connection-pool-name'},
        );
    }
}
