#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oid/getOIDPerfDetail.pl /main/5 2011/04/27 22:04:55 proxy Exp $
#
# getOIDPerfDetail.pl
# 
# Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIDPerfDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       04/18/11 - fix_bug_11904807
#    proxy       03/14/10 - fix_9470694
#    proxy       09/01/09 - Creation
# 

use ias::simpleXPath;
use IPC::Open2;

require "emd_common.pl";

my $host = $ARGV[0];
my $port = $ARGV[1];
my $username = $ARGV[2];
my $password = $ARGV[3];
my $oracleHome = $ARGV[4];
my $targetName = $ARGV[5];
my $os = $^O;
my $slash = '/';
my $indexOf = rindex($targetName,$slash);
my $displayName = substr($targetName,$indexOf+1);

my $cm;
my $cmd;
if(($os =~ "Win") || ($os =~ "MSWin32")) {
	EMAGENT_PERL_DEBUG("OS is Windows");
	$cm = $oracleHome."\\bin\\ldapsearch -U 1 -h $host -p $port -D \"$username\" -w $password -b \"cn=$displayName,cn=osdldapd,cn=subconfigsubentry\" -s sub \"(objectclass=*)\"";
}
else
{
	if(($os eq "hpux") || ($os eq "HPUX") || ($os eq "HP-UX")) 
	{
		EMAGENT_PERL_DEBUG("OS is HPUX");
		$ENV{LD_LIBRARY_PATH} = $oracleHome."/ldap/lib/:".$oracleHome."/lib/:";
		$ENV{SHLIB_PATH} = $oracleHome."/ldap/lib/:".$oracleHome."/lib/:";
	}
	if(($os eq "aix") || ($os eq "AIX"))
        {
                EMAGENT_PERL_DEBUG("OS is AIX");
                $ENV{LIBPATH} = $oracleHome."/ldap/lib/:".$oracleHome."/lib/:";
        }
	#setting ORACLE_HOME as env variable, in order to handle "Context Initialization Error" returned by ldapsearch in absence of the env variable.
	$ENV{ORACLE_HOME} = $oracleHome;
	$cm = $oracleHome."/bin/ldapsearch -U 1 -h $host -p $port -D \"$username\" -w $password -b \"cn=$displayName,cn=osdldapd,cn=subconfigsubentry\" -s sub \"(objectclass=*)\"";
}

#	EMAGENT_PERL_DEBUG("cmd:$cm");

my($OUT,$IN);
my $pid = open2($OUT,$IN,$cm);

close($IN);

my @propName = ("orclserverprocs","orclmaxcc","orclecacheenabled","orclecachemaxentries","orclecachemaxentsize","orclecachemaxsize","orclmaxconnincache","orclldapconntimeout","orclnwrwtimeout","orclmaxldapconns","orclmaxserverresptime","orcldispthreads","orclpluginworkers","orclgeneratechangelog","orclenablegroupcache");
my @results;
my $res;
my $line;
while($line = <$OUT>)
{
	chomp($line);
    push(@results, $line);    
}

close($OUT);
waitpid($pid, 0);

foreach $pName (@propName)
{
	foreach $line (@results)
    {
		if ($line =~ m/$pName/)
        {
			my $r = substr($line, (index($line, '=')+1));
            $r =~ s/\r//g;
            $res =  $res."|".$r;
        }
	}
}

$res = substr($res, 1);
print "em_result=$res\n";
