#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oif/getIdPSAML1xAssertProtoDetail.pl /main/3 2010/03/08 21:13:59 proxy Exp $
#
# getIdPSAML1xAssertProtoDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getIdPSAML1xAssertProtoDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       10/13/09 - fix bug 9003955
#    proxy       07/23/09 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $domainHome = $ARGV[0];

my $xmlFile; 

if(-e "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml"){
	$xmlFile = "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml"){
	$xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml"){
        $xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml";
}

my @oif;
my $temp;

my $enabledIdFormats;
my $defaultIdFormat;
my $getX500FromSession;
my $getEmailFromSession;
my $getWindowsFromSession;
my $getUnspecifiedFromSession;
my $getCustomFromSession;
my $nameFormatX500;
my $nameFormatEmail;
my $nameFormatWindows;
my $nameFormatUnspecified;
my $nameFormatCustom;
my $customNameIdFormat;
my $sendSignAssert;
my $saml11Enabled;
my $saml10Enabled;
my $attrResponderEnabled;
my $authnResponderEnabled;
my $assertIdResponderEnabled;
my $defaultSSOBinding;
my $requireSignReqSoap;
my $sendSignRespAssertPost;
my $sendSignRespAssertSoap;

@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="idpsaml10"]//PropertiesList[@name="nameidformats"]/Property');
foreach $temp (@oif) {
	if($enabledIdFormats){
		$enabledIdFormats = $enabledIdFormats . " , " . $temp;
	}
	else{
		$enabledIdFormats = $temp;
	}
}

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="defaultnameidformat"]');
$defaultIdFormat = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="nameformatx500fromsession"]');
$getX500FromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="nameformatemailfromsession"]');
$getEmailFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="nameformatwindowsfromsession"]');
$getWindowsFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="nameformatunspecifiedfromsession"]');
$getUnspecifiedFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="nameformatcustomfromsession"]');
$getCustomFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="nameformatx500"]');
$nameFormatX500 = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="nameformatemail"]');
$nameFormatEmail = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="nameformatwindows"]');
$nameFormatWindows = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="nameformatunspecified"]');
$nameFormatUnspecified = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="nameformatcustom"]');
$nameFormatCustom = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="customnameidformat"]');
$customNameIdFormat = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="sendsignedassertion"]');
$sendSignAssert = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml11"]//Property[@name="saml11enabled"]');
$saml11Enabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="saml10enabled"]');
$saml10Enabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="attributeresponderenabled"]');
$attrResponderEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="authnresponderenabled"]');
$authnResponderEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="assertionidresponderenabled"]');
$assertIdResponderEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="defaultssoresponsebinding"]');
$defaultSSOBinding = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="requiresignedrequestsoap"]');
$requireSignReqSoap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="sendsignedresponseassertionpost"]');
$sendSignRespAssertPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml10"]//Property[@name="sendsignedresponseassertionsoap"]');
$sendSignRespAssertSoap = $oif[0];


ias::asecm::printResult(
	$enabledIdFormats, 'string',
	$defaultIdFormat, 'string',
	$getX500FromSession, 'string',
	$getEmailFromSession, 'string',
	$getWindowsFromSession, 'string',
	$getUnspecifiedFromSession, 'string',
	$getCustomFromSession, 'string',
	$nameFormatX500, 'string',
	$nameFormatEmail, 'string',
	$nameFormatWindows, 'string',
	$nameFormatUnspecified, 'string',
	$nameFormatCustom, 'string',
	$customNameIdFormat, 'string',
	$sendSignAssert, 'string',
	$saml11Enabled, 'string',
	$saml10Enabled, 'string',
	$attrResponderEnabled, 'string',
	$authnResponderEnabled, 'string',
	$assertIdResponderEnabled, 'string',
	$defaultSSOBinding, 'string',
	$requireSignReqSoap, 'string',
	$sendSignRespAssertPost, 'string',
	$sendSignRespAssertSoap, 'string',
);
