#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oif/getOIFIdPConfigDetail.pl /main/3 2010/03/08 21:13:59 proxy Exp $
#
# getOIFIdPConfigDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFIdPConfigDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       10/13/09 - fix bug 9003955
#    proxy       07/22/09 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $domainHome = $ARGV[0];

my $xmlFile; 

if(-e "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml"){
	$xmlFile = "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml"){
	$xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml"){
        $xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml";
}

my @oif;

my $enableIdp;
my $providerId;
my $assertionValid;
my $reauthenticate;
my $sendSignAssert;
my $artifactTimeout;
my $enableCmnDomain;
my $cmnDomainUrl;
my $cmnDomainName;
my $cmnDmnCookieLife;
my $ssoMode;
my $ssoUserAttr;
my $ssoAttrValue;
my $forceAuth;

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="idpenabled"]');
$enableIdp = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="providerid"]');
$providerId = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="assertionvalidityinterval"]');
$assertionValid = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="reauthenticate"]');
$reauthenticate = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="sendsignedassertion"]');
$sendSignAssert = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="artifacttimeout"]');
$artifactTimeout = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="commondomainenabled"]');
$enableCmnDomain = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="commondomainurl"]');
$cmnDomainUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="commondomainname"]');
$cmnDomainName = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="commondomaincookielifetime"]'); 
$cmnDmnCookieLife = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="optssouser"]');
$ssoMode = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="optssouserattrname"]');
$ssoUserAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="optssouserattrvalue"]');
$ssoAttrValue = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpglobal"]//Property[@name="sessionattributeforceauthn"]');
$forceAuth = $oif[0];

ias::asecm::printResult(
	$enableIdp, 'string',
	$providerId, 'string',
	$assertionValid, 'number',
	$reauthenticate, 'number',
	$sendSignAssert, 'string',
	$artifactTimeout, 'number',
	$enableCmnDomain, 'string',
	$cmnDomainUrl, 'string',
	$cmnDomainName, 'string',
	$cmnDmnCookieLife, 'number',
	$ssoMode, 'string',
	$ssoUserAttr, 'string',
	$ssoAttrValue, 'string',
	$forceAuth, 'string',
);
