#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oif/getOIFIdPSAML20AssertPropDetail.pl /main/3 2010/03/08 21:13:59 proxy Exp $
#
# getOIFIdPSAML20AssertPropDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFIdPSAML20AssertPropDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       10/13/09 - fix bug 9003955
#    proxy       07/22/09 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $domainHome = $ARGV[0];

my $xmlFile; 

if(-e "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml"){
	$xmlFile = "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml"){
	$xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml"){
        $xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml";
}

my @oif;
my $temp;

my $enabledIdFormats;
my $defaultIdFormat;
my $getX500FromSession;
my $getEmailFromSession;
my $getWindowsFromSession;
my $getKerberosFromSession;
my $getUnspecifiedFromSession;
my $getCustomFromSession;
my $nameFormatX500;
my $nameFormatEmail;
my $nameFormatWindows;
my $nameFormatKerberos;
my $nameFormatUnspecified;
my $nameFormatCustom;
my $customNameIdFormat;
my $forceConsentUrl;
my $forceConsent;
my $sendEncryptAssert;
my $sendEncryptAttr;
my $sendEncryptNameId;
my $sendSignAssert;

@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="idpsaml20"]//PropertiesList[@name="nameidformats"]/Property');
foreach $temp (@oif) {
	if($enabledIdFormats){
		$enabledIdFormats = $enabledIdFormats . " , " . $temp;
	}
	else{
		$enabledIdFormats = $temp;
	}
}

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="defaultnameidformat"]');
$defaultIdFormat = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatx500fromsession"]');
$getX500FromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatemailfromsession"]');
$getEmailFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatwindowsfromsession"]');
$getWindowsFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatkerberosfromsession"]');
$getKerberosFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatunspecifiedfromsession"]');
$getUnspecifiedFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatcustomfromsession"]');
$getCustomFromSession = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatx500"]');
$nameFormatX500 = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatemail"]');
$nameFormatEmail = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatwindows"]');
$nameFormatWindows = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatkerberos"]');
$nameFormatKerberos = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatunspecified"]');
$nameFormatUnspecified = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="nameformatcustom"]');
$nameFormatCustom = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="customnameidformat"]');
$customNameIdFormat = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="forceconsenturl"]');
$forceConsentUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="forceconsent"]');
$forceConsent = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendencryptedassertion"]');
$sendEncryptAssert = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendencryptedattribute"]');
$sendEncryptAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendencryptednameid"]');
$sendEncryptNameId = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpsaml20"]//Property[@name="sendsignedassertion"]');
$sendSignAssert = $oif[0];

ias::asecm::printResult(
	$enabledIdFormats, 'string',
	$defaultIdFormat, 'string',
	$getX500FromSession, 'string',
	$getEmailFromSession, 'string',
	$getWindowsFromSession, 'string',
	$getKerberosFromSession, 'string',
	$getUnspecifiedFromSession, 'string',
	$getCustomFromSession, 'string',
	$nameFormatX500, 'string',
	$nameFormatEmail, 'string',
	$nameFormatWindows, 'string',
	$nameFormatKerberos, 'string',
	$nameFormatUnspecified, 'string',
	$nameFormatCustom, 'string',
	$customNameIdFormat, 'string',
	$forceConsentUrl, 'string',
	$forceConsent, 'string',
	$sendEncryptAssert, 'string',
	$sendEncryptAttr, 'string',
	$sendEncryptNameId, 'string',
	$sendSignAssert, 'string',
);
