#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oif/getOIFSPConfigDetail.pl /main/3 2010/03/08 21:13:59 proxy Exp $
#
# getOIFSPConfigDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFSPConfigDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       10/13/09 - fix bug 9003955
#    proxy       07/23/09 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $domainHome = $ARGV[0];

my $xmlFile; 

if(-e "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml"){
	$xmlFile = "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml"){
	$xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml"){
        $xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml";
}

my @oif;
my $temp;
my @dns;
my $dn;
my @idps;
my $idp;
my @authmech;

my $spEnabled;
my $providerId;
my $ssoAssertUsrMap;
my $anonyUsrId;
my $ignoreUnknownCond;
my $reqSignedAssert;
my $defaultSsoIdp;
my $idpDiscSrvcEnabled;
my $idpDiscSrvcUrl;
my $cmnDomainEnabled;
my $cmnDomainUrl;
my $attrRequesterEnabled;
my $defaultAttrAuth;
my $dnIdpMap;
my $authMechIdpMap;

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="spenabled"]');
$spEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="providerid"]');
$providerId = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="ssoassertionusermapping"]');
$ssoAssertUsrMap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="anonymoususerid"]');
$anonyUsrId = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="ignoreunknownconditions"]');
$ignoreUnknownCond = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="requiresignedassertion"]');
$reqSignedAssert = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="defaultssoidp"]');
$defaultSsoIdp = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="idpdiscoveryserviceenabled"]');
$idpDiscSrvcEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="idpdiscoveryserviceurl"]');
$idpDiscSrvcUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="commondomainenabled"]');
$cmnDomainEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="commondomainurl"]');
$cmnDomainUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="attributerequesterenabled"]');
$attrRequesterEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="dnidpmapping"]//Property[@name="defaultattrauthority"]');
$defaultAttrAuth = $oif[0];

@dns = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="dnidpmapping"]//PropertiesList[@name="dns"]/Property');
foreach $dn (@dns) {
	@idps = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="dnidpmapping"]//Property[@name="' . $dn . '"]');
	$idp = $idps[0];
	if($dnIdpMap){
		$dnIdpMap = $dnIdpMap . " ; " . $dn . " : " . $idp;
	}
	else{
		$dnIdpMap = $dn . " : " . $idp;
	}
}

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//PropertiesList[@name="authnmechssomappingmech"]');
@authmech = split(/\s+/,$oif[0]);
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//PropertiesList[@name="authnmechssomappingidp"]');
@idps = split(/\s+/,$oif[0]);

my $size = @idps;
my $i;
for ($i=1; $i<$size ; $i++) {
	if($idps[$i] ne "defaultssoidp"){
		if($authMechIdpMap){
			$authMechIdpMap = $authMechIdpMap . " ; " . $authmech[$i] . " : " . $idps[$i];
		}
		else{
			$authMechIdpMap = $authmech[$i] . " : " . $idps[$i];
		}
	}
}

ias::asecm::printResult(
	$spEnabled, 'string',
	$providerId, 'string',
	$ssoAssertUsrMap, 'string',
	$anonyUsrId, 'string',
	$ignoreUnknownCond, 'string',
	$reqSignedAssert, 'string',
	$defaultSsoIdp, 'string',
	$idpDiscSrvcEnabled, 'string',
	$idpDiscSrvcUrl, 'string',
	$cmnDomainEnabled, 'string',
	$cmnDomainUrl, 'string',
	$attrRequesterEnabled, 'string',
	$defaultAttrAuth, 'string',
	$dnIdpMap, 'string',
	$authMechIdpMap, 'string',
);
