#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/printWebLogicDomainAssociations.pl /main/1 2011/11/17 07:27:10 sasachde Exp $
#
# printWebLogicDomainAssociations.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      printWebLogicDomainAssociations.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sasachde    10/25/11 - Creation
# 

use strict;
use mwm::exalogicUtil;

my $hostName = shift(@ARGV);
my $oracleHome = $ENV{'WL_HOME'};

# Find the last association with a unique type, that has a target name
my %assocs = ();
for my $assoc (@ARGV)
{
    my @params = split('\|', $assoc);
    my $assocType = $params[0];
    my $targetName = $params[1];
    if ($targetName eq '' || $targetName =~ /^%.*%$/)
    {
        # Target name is missing
        next;
    }
    $assocs{$assocType} = $assoc;
}
# Print associations including the target property <host name>:<oracle home>
for my $assocType (keys %assocs)
{
    my $assoc = $assocs{$assocType};
    print "em_result=$assoc|$hostName:$oracleHome\n";
}

my $elAssoc = getExalogicAssoc();
if($elAssoc ne "")
{
  print $elAssoc;
}
