# 
# $Header: emas/sysman/admin/scripts/ias.10g/weblogic_j2eeserver/JMSConfigUtil.pm /main/1 2011/10/24 20:59:07 gisivaku Exp $
#
# JMSConfigUtil.pm
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      JMSConfigUtil.pm - Module for utility functions for working with JMS 
#                         Configuration.
#
#    DESCRIPTION
#      This file servs as a perl module defining utility functions that can be 
#      used while working with JMS Configurations.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gisivaku    08/30/11 - Perl Module defining utility functions useful while
#                           working with JMS Configurations. Initially created
#                           for retrieving the quota for detinations Queue and
#                           Topic.
#    gisivaku    08/30/11 - Creation
# 

package ias::weblogic_j2eeserver::JMSConfigUtil;

use strict;
use Exporter 'import';
use ias::simpleXPath;
use ias::weblogic_j2eeserver::ServerConfigUtil;

our @EXPORT = qw(
    getQuotas
    getSubDepolyments
);

#Returns a hash with the names of the quota parameter names mapped to the values.
#The following is the algo followed:
# 1: Check if the resouce specifies a quota. if yes get the quota parameters 
#    from the specified quota.
# 2: If resouce does not specify quota check if the resource specifies a template.
#    If it does, call the same subroutine with the template resource to retun 
#    the hash of quota parameters.
# 3: If resource is not based on template return empty hash.
#
#Params:
# 0 : Reference to the root node jms resource descriptor file obtained by parsing 
#     the file descriptor file using ias::simpleXPath.
# 1 : The tag name of the jms resource which identifyies the type of the resource.
#     Usually one of "queue", "topic", "template"
# 2 : The name of the JMS resource for which the quota values are to be retrieved.
sub getQuotas
{
    my ( $descriptorFileNode, $resourceType, $resouceName) = @_;
    
    my $reourceSelectorPath = 'weblogic-jms/'.$resourceType.'[@name="'.$resouceName.'"]';
    
    my $quotaName = (ias::simpleXPath::queryForText($descriptorFileNode, 
    "$reourceSelectorPath/quota"))[0];
    
    my %quotas = ();
    
    if ( defined($quotaName) )
    {
        my $quota = (ias::simpleXPath::queryForNodes($descriptorFileNode, 
        'weblogic-jms/quota[@name="'.$quotaName.'"]'))[0];
        for my $params (@{$quota->{'children'}})
        {
            my $child = undef;
            $child = $params->{'children'}->[0] if ($#{$params->{'children'}} == 0);
            $quotas{$params->{'tagName'}} = $child->{'text'} if (defined($child) && ($child->{'type'} eq 'text'));
        }
        for my $attr (keys(%{$quota->{'attributes'}}))
        {
            $quotas{$attr} = $quota->{'attributes'}->{$attr};
        }
    }
    else
    {
        my $templateName = (ias::simpleXPath::queryForText($descriptorFileNode, 
        "$reourceSelectorPath/template"))[0];
        if (defined($templateName))
        {
            return getQuotas($descriptorFileNode, "template", $templateName);
        }
    }
    return %quotas;
}

#Returns a hash containing the names of subdeployments targetted to the specified 
#server mapped against the targets names as csv for the specified jms-system-resource.
#
#Params:
# 0 : Reference to the root node of the domains config file obtained by parsing 
#     the config.xml using ias::simpleXPath.
# 1 : The name of the server The subdeployments targetted to whichare to be retrieved.
# 2 : The name of the jms-system-resource whose sub deplyments are to be obtained.
sub getSubDepolyments
{
    my ($configFile, $serverName, $resourceName) = @_;
    my @servers = getServerComponentNames($configFile, 'jms-server', $serverName);
    push (@servers, $serverName, getServerCluster($configFile, $serverName));
    return ias::weblogic_j2eeserver::ServerConfigUtil::getRefServersComponentTargets(
    $configFile, 'jms-system-resource[name="' . $resourceName . '"]/sub-deployment', \@servers);        
}

return 1;
