#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/weblogic_j2eeserver/NodeManager.pl /main/2 2011/12/20 00:33:32 sasachde Exp $
#
# NodeManager.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      NodeManager.pl - Obtains NodeManager Config metric values in OCM context
#
#    DESCRIPTION
#      This perl script is used for obtaing the NodeManager config metric values 
#      in the OCM context. this script is called through the OSLineToken fetchlet
#
#    NOTES
#      Arguments:
#        1: The value of the WL_HOME (The directory where the Weblogic server is 
#           installed).
#
#    MODIFIED   (MM/DD/YY)
#    sasachde    12/15/11 - Fix for bug#13450256
#    gisivaku    09/06/11 - Perl script for obtaing the values for the
#                           NodeManager congig metric in the OCM context.
#    gisivaku    09/06/11 - Creation
# 

use strict;
use File::Spec;
use ias::propertiesFileParser;
require "emd_common.pl";

my ( $wlHome ) = @ARGV;

my $nodeManagerPropertiesFilePath = "${wlHome}/common/nodemanager/nodemanager.properties";
if (! -e $nodeManagerPropertiesFilePath)
{
  EMD_PERL_DEBUG("NodeManager metric collection skipped because nodemanager.properties file does not exist: '$nodeManagerPropertiesFilePath'");
}

else {
my %properties = parsePropertiesFile($nodeManagerPropertiesFilePath);

print 'em_result='
                  . $properties{'ListenAddress'}
            . '|' 
            . '|' 
            . '|' . $properties{'ListenPort'}
            . '|' 
            . '|' . $properties{'StartScriptEnabled'}
            . "\n";
}
