#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/weblogic_j2eeserver/SharedWeblogicHome.pl /main/1 2011/11/14 03:37:48 gisivaku Exp $
#
# SharedWeblogicHome.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      SharedWeblogicHome.pl - Script for collecting SharedWeblogicHome metric.
#
#    DESCRIPTION
#      Perl script to retrieve the Shared Weblogic Home config metric called by 
#      the OSLineToken fetchlet.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gisivaku    11/04/11 - Changed code to return the host and WebLogic Home
#                           arguments provided as the BinaryHost and Binary
#                           WeblogicHome if the Weblogic home is on a local
#                           file system following feedback requesting for the
#                           same from Ashish Maurya.
#    gisivaku    10/28/11 - Added check for the parameter webLogicHome as it is
#                           obtained from the optional instance property
#                           WebLogicHome and tracing a debug statement if the
#                           parameter is not supplied.
#    gisivaku    10/27/11 - Updated the message written to the trace if the
#                           weblogic target is not monitored by local agent
#                           based on Saurabh's feedback.
#    gisivaku    10/19/11 - Perl script to retrieve the Shared Weblogic Home
#                           metric.
#    gisivaku    10/19/11 - Creation
# 

use strict;
use Cwd;
use File::Spec;
use Net::Domain qw(hostname domainname);

require "emd_common.pl";

use ias::weblogic_j2eeserver::ServerConfigUtil;

my ( $deployedHost, $webLogicHome ) = @ARGV;

EMD_PERL_DEBUG( 'Parameter: host  => ' . $deployedHost);
EMD_PERL_DEBUG( 'Parameter: wlHome => ' . $webLogicHome);

if ($webLogicHome)
{
    my $hostName = hostname();
    my $cannonicalHostName = domainname();
    
    if ($deployedHost eq $hostName || $deployedHost eq $cannonicalHostName)
    {
        my $realWebLogicHomePath = Cwd::realpath($webLogicHome);
        my ( $volume,$directories,$file ) = File::Spec->splitpath( $realWebLogicHomePath, 1 );
        
        EMD_PERL_DEBUG( 'volume => ' . $volume);
        EMD_PERL_DEBUG( 'directories => ' . $directories);
        EMD_PERL_DEBUG( 'file => ' . $file);
        
        my %mounts = getMounts;
        
        my $rootDir = File::Spec->rootdir();
        my $mountSource;
        my $wlHomeRelativeToMountPoint;
        
        if ($volume)
        {
            $mountSource = $mounts{$volume};
            $wlHomeRelativeToMountPoint = $directories;
        }
        else
        {
            my $rootDir = File::Spec->rootdir();
            my $upDir = File::Spec->updir();
            $mountSource = $mounts{$directories};
            while ( !defined($mountSource) && $directories ne $rootDir)
            {
                $directories = Cwd::realpath( File::Spec->rel2abs( $upDir, $directories ) );
                $mountSource = $mounts{$directories};
            }
            $volume = $directories;
            $wlHomeRelativeToMountPoint = File::Spec->abs2rel( $realWebLogicHomePath, $volume ) ;
        }
        
        EMD_PERL_DEBUG( 'volume => ' . $volume);
        EMD_PERL_DEBUG( 'Weblogic Home Relative to Mount Point => ' . $wlHomeRelativeToMountPoint);
        EMD_PERL_DEBUG( 'Mount Source => ' . $mountSource);
        
        my ( $binaryHost, $binaryExport, $binaryWLHome );
        
        if ($mountSource =~ /.*:.*/)
        {
            ( $binaryHost, $binaryExport ) = split ( /:/, $mountSource, 2 );
            if ($binaryExport)
            {
                $binaryWLHome = File::Spec->catdir( $binaryExport, $wlHomeRelativeToMountPoint);
            }
        }
	else
	{
            $binaryHost = $deployedHost;
	    $binaryWLHome = $webLogicHome;
	}
        
        EMD_PERL_DEBUG( 'binaryHost => ' . $binaryHost);
        EMD_PERL_DEBUG( 'binaryWLHome => ' . $binaryWLHome);
        
        print('em_result=' . $binaryHost . '|' . $binaryWLHome . "\n");
    }
    else
    {
        EMD_PERL_DEBUG('The target is remotely monitored by the agent. ' . 
        'Hence the metric SharedWebLogicHomeHidden will not be collected for the target.');
    }
}
else
{
    EMD_PERL_DEBUG('The instance property WebLogicHome is not available. ' . 
    'The metric SharedWebLogicHomeHidden cannot not be collected for the target.');
}

