#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/weblogic_j2eeserver/StartupShutdownClasses.pl /main/2 2011/04/21 04:28:24 sasachde Exp $
#
# StartupShutdownClasses.pl
# 
# Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      StartupShutdownClasses.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sasachde    04/10/11 - Fix for bug#9716634
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     11/07/08 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::weblogic_j2eeserver::ServerConfigUtil;

my ( $domainHome, $serverName, $adminServer ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my @startupClasses = getServerComponentNames($configFile, 'startup-class', $serverName);
for my $name (@startupClasses)
{
    my $class = (ias::simpleXPath::queryForNodes($configFile,
        'domain/startup-class[name="' . $name . '"]'))[0];
    print 'em_result=' . $name . '|startup'
    . '|' . (ias::simpleXPath::queryForText($class, 'startup-class/class-name'))[0]
    . '|' . (ias::simpleXPath::queryForText($class, 'startup-class/deployment-order'))[0]
    . '|'
    ;
    print "\n";
}

my @shutdownClasses = getServerComponentNames($configFile, 'shutdown-class', $serverName);
for my $name (@shutdownClasses)
{
    my $class = (ias::simpleXPath::queryForNodes($configFile,
        'domain/shutdown-class[name="' . $name . '"]'))[0];
    print 'em_result=' . $name . '|shutdown'
    . '|' . (ias::simpleXPath::queryForText($class, 'shutdown-class/class-name'))[0]
    . '|' . (ias::simpleXPath::queryForText($class, 'shutdown-class/deployment-order'))[0]
    . '|'
    . "\n";
}
