#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/webtierConfig.pm /main/4 2012/04/15 03:56:09 rahgupta Exp $
#
# webtierConfig.pm
# 
# Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      webtierConfig.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    smariswa    02/12/12 - Fix Bug 13608322
#    skotha      08/19/09 - Creation
# 
#!/usr/bin/perl
package ias::webtierConfig;

use strict;
use Fcntl; 
use File::Spec::Functions;
use Exporter 'import';
use File::Path;

our @EXPORT = qw(
    fetchConfigFile
    writeXmlContentToFile
);

my $configFilePath;

sub fetchConfigFile {
    my $serviceUrl = $_[0];
    my $mbeanObjectName = $_[1];
    my $methodName = $_[2];
    my $fileName = $_[3];
    my $agentHome = $ENV{ORACLE_HOME};
    my $AGENT_PLUGIN_ROOT = $ENV{'PLUGIN_ROOT'};
    my $agentStateDir = $ENV{EMSTATE};

    my $java = catfile($agentHome, 'jdk', 'bin', 'java');

    my $agentTrust = catfile($agentStateDir, "sysman", "config", "montrust", "AgentTrust.jks");
    my $trustStoreProps = "-Dssl.debug=false -Djavax.net.ssl.trustStore=$agentTrust -Dweblogic.security.TrustKeyStore=CustomTrust -Dweblogic.security.CustomTrustKeyStoreFileName=$agentTrust -Dweblogic.security.SSL.enforceConstraints=off -Dweblogic.security.SSL.ignoreHostnameVerification=true";

    my $emdjavajar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'emd_java.jar');
    my $wljmxclientjar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'wljmxclient.jar');

    my $cpsep = ":";
    if(&IsWindows() ) {
	$cpsep = ";";
    }
    my $classpath = $emdjavajar . $cpsep . $wljmxclientjar;
    my $className = 'oracle.sysman.emas.model.webcache.RemoteConfigXmlUtil';
    my $command = $java . ' ' . $trustStoreProps . ' -classpath ' . $classpath . ' ' . $className . ' ' . $serviceUrl . ' ' . $mbeanObjectName . ' ' . $methodName . ' ' . $fileName;
    my $xmlString = `$command`;
    return $xmlString;
}

#Takes 3 arguments 
	#File Name
	#Target file path
	#Content to write
sub writeXmlContentToFile
{
    my $confFileName = $_[0];
    my $targetDir = $_[1];
    my $confFileContent = $_[2];

    my $fileName = File::Spec->catfile($targetDir, $confFileName);

    mkpath $targetDir;

    open CONF_FILE, ">$fileName" or die "unable to open $fileName $!";
    print CONF_FILE "$confFileContent";
    close(CONF_FILE);
    my $sysCommand = "perl -p -i -e 's/\r//' $fileName"; 
    system($sysCommand);
}


sub IsWindows {
    my $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}

return 1;
