#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/idmDiscovery.pl /main/5 2011/05/12 11:33:23 kchander Exp $
#
# idmDiscovery.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      idmDiscovery.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kchander    05/06/11 - fix plugin root issue.
#    kchander    09/07/10 - fix bug 10074126.
#    kchander    01/05/09 - fix bug 7666162.
#    skpanigr    11/25/06 - sqlserver update
#    skpanigr    10/27/06 - Creation
# 
require "emd_common.pl";

		chomp($os = $^O);
        while(<@ARGV>)
    	{
            ($xlLibPath,$url,$jdbcdriver,$userName,$pwd) = split(/\|/);
    	}
        #use EMDROOT, instead of ORACLE_HOME, see bug 10074126
        my $oraHome = $ENV{EMDROOT};
        my $classpath;
        my $args;
        my @cmd ;
        my $command = $oraHome."/jdk/bin/java -Doracle.home=".$oraHome;
		$command = $command." -Dlog4j.configuration=file:/".$oraHome."/sysman/config/emagentlogging.properties";
        $classpath = getClasspath($oraHome, $os, $url);
        $command = $command." -classpath ".$classpath." oracle.sysman.idm.agent.IdmDiscover";
        $args = $xlLibPath;
        if(defined $url) {
                $args = $args." ".$url." ".$jdbcdriver." ".$userName." ".$pwd;
        }
        $command = $command." ".$args;
        @cmd=($command);
		EMAGENT_PERL_DEBUG("command:$command");
        my $result = system(@cmd);

     sub getClasspath
     {
        my $oracleHome = @_[0];
        my $OSNAME = @_[1];
        my $dburl = @_[2];
        my $classpath;
        my $pathSep;
        my $fileSep;
        if (($OSNAME ne "MSWin32") && ($OSNAME ne "MSWin64"))
        {
            $pathSep=":";
			$fileSep="/";
        }
        else
        {
            $pathSep=";";
			$fileSep="\\";
        }
	    my $pluginRoot = $ENV{PLUGIN_ROOT};
        $classpath =  $oracleHome."/sysman/jlib/log4j-core.jar".$pathSep.
		$oracleHome."/sysman/jlib/emCORE.jar".$pathSep.
		$oracleHome."/sysman/jlib/emagentSDK.jar".$pathSep.
		$pluginRoot."/archives/jlib/oimAgent.jar".$pathSep.
		$oracleHome."/lib/emagentALL.jar".$pathSep.
		$oracleHome."/jlib/dms.jar".$pathSep.
		$oracleHome."/jlib/ojdl.jar";
	if(defined $dburl) {
		$LSTFILE = $oracleHome.$fileSep."sysman".$fileSep."config".$fileSep."classpath.lst";
		open(LSTFILE) or die("Could not open classpath.lst file.");
		foreach $line (<LSTFILE>) {
			chomp($line);
			$line =~ s/^\s+|\s+$//g ;
            if (($line !~ m/^(#)/i) && ($line =~ m/(sqljdbc.jar|mssqlserver.jar|msutil.jar|msbase.jar)$/))
            {
				$classpath=$classpath.$pathSep.$line;
			}
		}
		close(LSTFILE);
	}
        return $classpath;
    }
    1;
