#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/idmRMStatus.pl /main/6 2011/07/01 16:11:01 kchander Exp $
#
# idmRMStatus.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      idmRMStatus.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kchander    06/20/11 - Fix bug 12600206.
#    kchander    05/06/11 - Fix plugin root issue.
#    kchander    09/07/10 - fix bug 10074126.
#    kchander    01/05/09 - fix bug 7666162.
#    aachanda    10/22/08 - Bug 7487231
#    skpanigr    11/25/06 - Creation
# 


use ParseStdin;
use strict;
use DBI;
use Time::HiRes;

require "emd_common.pl";
ParseStdin::initStdin();
my $userName = ParseStdin::getParameter("USERNAME");
my $pwd = ParseStdin::getParameter("PASSWORD");
EMAGENT_PERL_DEBUG("ARGV:@ARGV");
my $os;
chomp($os = $^O);
my $dbType = $ARGV[0];
my $step = $ARGV[1];
my $args = $dbType." ".$step;
my $xlhome;
if($dbType eq "oracle_database") {
	my $host = $ARGV[2];
	my $port = $ARGV[3];
	my $sid = $ARGV[4];
	$xlhome = $ARGV[7];
	my $emdroot = $ARGV[8];
    $args = $args." ".$host." ".$port." ".$sid." ".$userName." ".$pwd." ".$xlhome." ".$emdroot;
} else
{
	my $url = $ARGV[2];
	my $jdbcdriver = $ARGV[3];
	$xlhome = $ARGV[6];
	my $emdroot = $ARGV[7];
    $args = $args." ".$url." ".$jdbcdriver." ".$userName." ".$pwd." ".$xlhome." ".$emdroot;
}

my $oraHome = $ENV{EMDROOT};
my $classpath = getClasspath($oraHome, $os, $xlhome, $dbType);
my $command = $oraHome."/jdk/bin/java -Doracle.home=".$oraHome;
$command = $command." -Dlog4j.configuration=file:/".$oraHome."/sysman/config/emagentlogging.properties";
$command = $command." -classpath ".$classpath." oracle.sysman.idm.agent.OIMAgentUtility";
$command = $command." ".$args;
EMAGENT_PERL_DEBUG("cmd is $command");
my $result = `$command`;
EMAGENT_PERL_DEBUG("result is $result");
print "em_result=$result\n";
exit 0;
	
sub getClasspath
{
	my $oracleHome = @_[0];
	my $OSNAME = @_[1];
	my $XLHOME = @_[2];
	my $DBTYPE = @_[3];
	my $classpath;
	my $pathSep;
	my $fileSep;
	if (($OSNAME ne "MSWin32") && ($OSNAME ne "MSWin64"))
	{
		$pathSep=":";
		$fileSep="/";
	}
	else
	{
		$pathSep=";";
		$fileSep="\\";
	}
    my $pluginRoot = $ENV{PLUGIN_ROOT};
	$classpath =  
		$pluginRoot."/archives/jlib/oimAgent.jar".$pathSep.
		$XLHOME."/lib/xlCrypto.jar".$pathSep.
		$XLHOME."/lib/xlUtils.jar".$pathSep.
		$XLHOME."/lib/xlLogger.jar".$pathSep.
		$XLHOME."/lib/xlRemoteManager.jar".$pathSep.
		$XLHOME."/ext/log4j-1.2.8.jar";
	if($dbType eq "oracle_database") 
	{
		$classpath = $classpath.$pathSep.$oracleHome."/jdbc/lib/ojdbc14.jar";
	}
	else
	{
		my $LSTFILE = $oracleHome.$fileSep."sysman".$fileSep."config".$fileSep."classpath.lst";
		EMAGENT_PERL_DEBUG("LSTFILE:$LSTFILE");
		open(LSTFILE, $LSTFILE) or die("Could not open classpath.lst file.");
		EMAGENT_PERL_DEBUG("File Opened...");
		my $line;
		foreach $line (<LSTFILE>) {
			chomp($line);
			$line =~ s/^\s+|\s+$//g ;
            if (($line !~ m/^(#)/i) && ($line =~ m/(sqljdbc.jar|mssqlserver.jar|msutil.jar|msbase.jar)$/))
            {
				$classpath=$classpath.$pathSep.$line;
			}
		}
		close(LSTFILE);
	}
	EMAGENT_PERL_DEBUG("classpath:$classpath");
	return $classpath;
}


