#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/idmrepos_status.pl /main/4 2011/05/12 11:33:23 kchander Exp $
#
# idmrepos_status.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      idmrepos_status.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kchander    05/06/11 - Fix plugin root issue.
#    kchander    09/07/10 - fix bug 10074126.
#    kchander    01/05/09 - fix bug 7666162.
#    aachanda    10/22/08 - Bug 7487231
#    skpanigr    11/25/06 - update for sqlserver
#    skpanigr    10/28/06 - 
#    nsarkar     09/15/06 - 
#    skpanigr    09/01/06 - Creation
# 

use ParseStdin;
use DBI;
use Time::HiRes;

require "emd_common.pl";
ParseStdin::initStdin();
my $userName = ParseStdin::getParameter("USERNAME");
my $pwd = ParseStdin::getParameter("PASSWORD");
my $os;
chomp($os = $^O);
my $dbType = $ARGV[0];

if($dbType eq "oracle_database") {
	my $tgtAddress = $ARGV[1];
	my $start_time = Time::HiRes::time;
	my $db = DBI->connect('dbi:Oracle:', $userName."@".$tgtAddress, $pwd);
	if (not defined $db) {
	  print "em_result=0|0|Could not connect $DBI::errstr\n";
	  ## We still return with exit 0 instead of exit 1 because otherwise it would
	  ## be considered as fetchlet failure.
	  exit 0;
	}
	my $end_time = Time::HiRes::time;
	$db->disconnect;
	# the end_time and start_time returned are in terms of seconds,
	# the logon_time should be in miliseconds
	my $logon_time = $end_time - $start_time;
	print "em_result=1|$logon_time|No errors\n";
	exit 0;
}
else
{
	my $dbType = $ARGV[0];
	my $step = $ARGV[1];
	my $url = $ARGV[2];
	my $jdbcdriver = $ARGV[3];
	my $xlhome = $ARGV[4];
	my $emdroot = $ARGV[5];
    my $oraHome = $ENV{EMDROOT};
    my $classpath;
    my $args;
    my @cmd ;
    my $command = $oraHome."/jdk/bin/java -Doracle.home=".$oraHome;
	$command = $command." -Dlog4j.configuration=file:/".$oraHome."/sysman/config/emagentlogging.properties";
    $classpath = getClasspath($oraHome, $os, $xlhome);
    $command = $command." -classpath ".$classpath." oracle.sysman.idm.agent.OIMAgentUtility";
    $args = $dbType." ".$step." ".$url." ".$jdbcdriver." ".$userName." ".$pwd." ".$xlhome." ".$emdroot;
	$command = $command." ".$args;
	@cmd=($command);
	EMAGENT_PERL_DEBUG("command:$command");
	my $result = `$command`;
	print ("em_result=$result\n");
    EMAGENT_PERL_DEBUG("em_result=$result\n");
	exit 0;
}

  sub getClasspath
     {
        my $oracleHome = @_[0];
        my $OSNAME = @_[1];
        my $XLHOME = @_[2];
        my $classpath;
        my $pathSep;
        my $fileSep;
		EMAGENT_PERL_DEBUG("OSNAME:$OSNAME");
        if (($OSNAME ne "MSWin32") && ($OSNAME ne "MSWin64"))
        {
            $pathSep=":";
			$fileSep="/";
        }
        else
        {
            $pathSep=";";
			$fileSep="\\";
        }
	    $pluginRoot = $ENV{PLUGIN_ROOT};
        $classpath =  
			$pluginRoot."/archives/jlib/oimAgent.jar".$pathSep.
			$XLHOME."/lib/xlCrypto.jar".$pathSep.
			$XLHOME."/lib/xlUtils.jar".$pathSep.
			$XLHOME."/lib/xlLogger.jar".$pathSep.
			$XLHOME."/lib/xlRemoteManager.jar".$pathSep.
			$XLHOME."/ext/log4j-1.2.8.jar";
		my $LSTFILE = $oracleHome.$fileSep."sysman".$fileSep."config".$fileSep."classpath.lst";
		open(LSTFILE, $LSTFILE) or die("Could not open classpath.lst file.");
		my $line;
		foreach $line (<LSTFILE>) {
			chomp($line);
			$line =~ s/^\s+|\s+$//g ;
            if (($line !~ m/^(#)/i) && ($line =~ m/(sqljdbc.jar|mssqlserver.jar|msutil.jar|msbase.jar)$/))
            {
				$classpath=$classpath.$pathSep.$line;
			}
		}
		close(LSTFILE);
		return $classpath;
}
1;
