import sys
from java.io import * 
from java.lang import String

input = BufferedReader(InputStreamReader(System.in))
 
# Read common arguments 
username = input.readLine()
password = input.readLine()
url = input.readLine()
appname = input.readLine()
appver = input.readLine()
archivefile = input.readLine()
targets = input.readLine()
planfile = input.readLine()
startmode = input.readLine()

# Read deploy-specific arguments
stagemode = input.readLine()
gracefullyretire = input.readLine()
timeoutretire = input.readLine()

isSharedLib = input.readLine()

print "======================================================================="
print "start deploying application " + appname
print "======================================================================="

if appver == "n/a":
    appver = "";

if planfile == "n/a":
    planfile = "";

if stagemode == "DEFAULT":
    stagemode = None;

adminMode = "false"
if startmode == "admin":
  adminMode = "true"

print "username :" + username
print "url      :" + url
print "appname  :" + appname
print "appver   :" + appver
print "archive  :" + archivefile
print "targets  :" + targets
print "plan     :" + planfile
print "Shared Lib: " + isSharedLib
print "startmode:" + startmode
if stagemode == None:
    print "stagemode: " + "Default";
else: 
    print "stagemode:" + stagemode
print "adminmode:" + adminMode

exitCode = 0

try:
    connect(username,password,url)

    if startmode == "full" or startmode == "admin":
        progress = deploy(appname, 
                  archivefile, 
                  targets, 
                  stagemode, 
                  planfile, 
                  testMode=adminMode, 
                  versionIdentifier=appver, 
		  upload=true,
		  timeout=300000,
		  libraryModule=isSharedLib)
    elif startmode == "distribute":  
        progress = distributeApplication(archivefile, planfile)

    if progress.isRunning() == false and progress.isCompleted() == false :
        exitCode = 1
except:
    exitCode = 1;

# This should be called always to make sure the lock is released.
disconnect()

if exitCode==0:
  print "======================================================================="
  print "Deployment completed successfully."
  print "======================================================================="
else:
  sys.stderr.write('=======================================================================\n')
  sys.stderr.write('Deployment failed.\n')
  sys.stderr.write('=======================================================================\n')

sys.exit(exitCode)

