import sys

print "======================================================================="
print "Start predeployment scripts. It will do:"
print "  1. Create the system datasource required by application.             "
print "  2. Custmoze the deployment plan,                                     "
print "     a) Map the resource reference to the JNDI name of the datasource created "
print "     b) Set the context-root to root2 "
print "     a) Set the session timeout to 10000"
print ""
print "After completed, we should see 1) new datasouece myJDBCDataSource created, "
print "                               2) a new plan.xml generated with above customization."
print "======================================================================="

print ""
print ""


print "======================================================================="
print "Start creating datasource ..."
print "======================================================================="


username = sys.argv[1]
password = sys.argv[2]
url = sys.argv[3]
appname = sys.argv[4]
appver = sys.argv[5]
archivefile = sys.argv[6]
targets = sys.argv[7]
planfile = sys.argv[8]
startmode = sys.argv[9]

print "username :" + username
print "url      :" + url
print "appname  :" + appname
print "appver   :" + appver
print "archive  :" + archivefile
print "targets  :" + targets
print "plan     :" + planfile
print "startmode:" + startmode

connect(username,password,url)


try:
  edit()
  # Change these names as necessary
  dsname="myJDBCDataSource"
  server="AdminServer"
  cd("Servers/"+server)
  target=cmo
  cd("../..")
  startEdit()

  # start creation
  print 'Creating JDBCSystemResource with name '+dsname
  jdbcSR = create(dsname,"JDBCSystemResource")
  theJDBCResource = jdbcSR.getJDBCResource()
  theJDBCResource.setName(dsname)

  connectionPoolParams = theJDBCResource.getJDBCConnectionPoolParams()
  connectionPoolParams.setConnectionReserveTimeoutSeconds(25)
  connectionPoolParams.setMaxCapacity(100)
  connectionPoolParams.setTestTableName("1")

  dsParams = theJDBCResource.getJDBCDataSourceParams()
  dsParams.addJNDIName("DsCreatedFromDP1")

  driverParams = theJDBCResource.getJDBCDriverParams()
  driverParams.setUrl("jdbc:oracle:thin:@//[HOST][:PORT]/SERVICE")
  driverParams.setDriverName("oracle.jdbc.OracleDriver")
  driverParams.setPassword("[PASSWORD]")

  driverProperties = driverParams.getProperties()
  proper = driverProperties.createProperty("user")
  proper.setValue("[USER]")

  jdbcSR.addTarget(target)

  save()

  activate(block="true")
  print "======================================================================="
  print "Datasource created."
  print "======================================================================="
except:
  undo("true", "y")
  stopEdit("y")
  print "======================================================================="
  print "Exception occured while creating datasource."
  print "======================================================================="




print ""
print ""
print "====================================="
print "start customizing deployment plan ..."
print "====================================="


plan=loadApplication(archivefile, planfile)

v1 = plan.createVariable("jspexpr_contextRoot_00001", "root2")
va1= plan.createVariableAssignment("jspexpr_contextRoot_00001", "jspE.ear", "META-INF/application.xml")
va1.setXpath("/application/module/web/[context-root=\"/jspexpr\"]/context-root")
va1.setOperation("replace")

v2 = plan.createVariable("essionDescriptor_TimeoutSecs_00001", "10000")
va2= plan.createVariableAssignment("essionDescriptor_TimeoutSecs_00001", "jspExpressionWar.war", "WEB-INF/weblogic.xml")
va2.setXpath("/weblogic-web-app/session-descriptor/timeout-secs")

v3 = plan.createVariable("demoDataSource_JNDIName_00001", "DsCreatedFromDP1")
va3= plan.createVariableAssignment("demoDataSource_JNDIName_00001", "jspExpressionWar.war", "WEB-INF/weblogic.xml")
va3.setXpath("/weblogic-web-app/resource-description/[res-ref-name=\"jdbc/demoDataSource\"]/jndi-name")

plan.save()

print "====================================="
print "Customizing deployment plan completed."
print "====================================="

disconnect()


print ""
print ""
print "======================================================================="
print " Predeployment scripts completed."
print "======================================================================="
print ""
print ""

# raise Exception



