import sys
from java.io import * 
from java.lang import String

input = BufferedReader(InputStreamReader(System.in))
 
# Read common arguments 
username = input.readLine()
password = input.readLine()
url = input.readLine()
appname = input.readLine()
appver = input.readLine()
archivefile = input.readLine()
targets = input.readLine()
planfile = input.readLine()
startmode = input.readLine()

# Read deploy-specific arguments
stagemode = input.readLine()
gracefullyretire = input.readLine()
timeoutretire = input.readLine()

isSharedLib = input.readLine()

print "======================================================================="
print "start redeploying application " + appname
print "======================================================================="

if appver == "n/a":
    appver = "";

if planfile == "n/a":
    planfile = "";

adminMode = "false"
if startmode == "admin":
  adminMode = "true"

if gracefullyretire == "n/a":
   gracefullyretire = ""

if timeoutretire == "0":
   timeoutretire = "-1"

if timeoutretire == "n/a":
   timeoutretire = ""

print "username :" + username
print "url      :" + url
print "appname  :" + appname
print "appver   :" + appver
print "archive  :" + archivefile
print "plan     :" + planfile
print "Shared Lib: " + isSharedLib
print "gracefullyretire:" + gracefullyretire
print "timeoutretire:" + timeoutretire
print "adminmode:" + adminMode

exitCode = 0

try:
    connect(username,password,url)

    progress = redeploy(appname, 
                  planfile, 
		  appPath=archivefile,
                  testMode=adminMode, 
                  versionIdentifier=appver, 
                  retireGracefully=gracefullyretire, 
		  libraryModule=isSharedLib,
                  retireTimeout=timeoutretire)

    if progress.isRunning() == false and progress.isCompleted() == false :
        exitCode = 1
except:
    exitCode = 1;

# This should be called always to make sure the lock is released.
disconnect()

if exitCode==0:
  print "======================================================================="
  print "Redeployment completed successfully."
  print "======================================================================="
else:
  sys.stderr.write('=======================================================================\n')
  sys.stderr.write('Redeployment failed.\n')
  sys.stderr.write('=======================================================================\n')

sys.exit(exitCode)

