#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/jbossdiscovery.pl /main/10 2010/09/14 23:52:43 vdwaram Exp $
#
# jbossdiscovery.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      jbossdiscovery.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vdwaram     09/08/10 - Change oraclehome to emdroot
#    spandita    06/02/10 - NG Compliance
#    spandita    11/11/09 - 8974599 - replace check for dom4j.jar with jboss-client.jar
#    spandita    01/13/09 - 7705104
#    ramehta     11/21/06 - fixing windows local discovery bug
#    vepadman    10/16/06 - XbranchMerge vepadman_bug-5566014 from main
#    vepadman    09/20/06 - XbranchMerge vepadman_bug-5521776 from main
#    vepadman    01/06/06 - 
#    ssuggala    12/06/05 - working
#    rxgoyal     12/06/05 - Discovery for JBoss. 
#    rxgoyal     12/06/05 - Creation
# 
#print "Start 0\n"; 
discover(@ARGV);
my $inputLength;
sub discover
{
  #open(ERROR,">error.txt") || die $!;
  print ERROR "@_\n";
  #print "Discover 0 \n"; 
    while(<@_>)
    {
        $inputLength = (@_[0] =~ tr/\|//);
        if($inputLength < 6)
        {
            ($installhome, $jndiport, 
                $lib, $jbosshost, $keyStoreFile) = 
            split(/\|/);

        }
        else
        {
            ($usrname, $password, $installhome, $jndiport, 
                $lib, $jbosshost, $keyStoreFile) = 
            split(/\|/);
        }
    }
    #print ERROR "UserName=$username\n";
    #print ERROR "Password=$password\n";    
    #print ERROR "Port=$jndiport\n";
    #print ERROR "Lib=$lib\n";
    #print ERROR "Host=$jbosshost\n";
    #print ERROR "KeystoreFile=$keyStoreFile\n";
    #print ERROR "InstallHome=$installhome\n";

    #print "UserName=$username\n";
    #print "Password=$password\n";    
    #print "InstallHome=$installhome\n";
    #print "Port=$jndiport\n";
    #print "Lib=$lib\n";
    #print "Host=$jbosshost\n";
    #print "KeystoreFile=$keyStoreFile\n";
    
    $jndiport = trim($jndiport);
    $lib = trim($lib);
    $jbosshost = trim($jbosshost);
    
    my $emdRoot = $ENV{EMDROOT};
    my $home = $ENV{HOME};
    my $classpath;
    my $plugin_root = $ENV{PLUGIN_ROOT};
    my $jboss_discovery_class = "oracle.sysman.emas.thirdparty.discovery.jboss.JBossDiscovery";
    #work around copied the plugin jar to plugin_root as disc_root is not available
    my $discovery_root = $plugin_root;    
    my $empty = "EMPTY";
    #chomp($os = $^O);
    if ($lib and $lib ne /^$/)
    {
        #print ERROR "Command with host given".$jbosshost."**\n";
        if (! -e $lib."/jbossall-client.jar")
        {
            print "11";
            exit(0);
        }
        if (! -e $lib."/jboss-management.jar")
        {
            print "11";
            exit(0);
        }
        if (! -e $lib."/jnp-client.jar")
        {
            print "11";
            exit(0);
        }
        if (! -e $lib."/jboss-client.jar")
        {
            print "11";
            exit(0);
        }
        $classpath = getRemoteClasspath($lib);
        $command = $emdRoot."/jdk/bin/java -Doracle.home=".$emdRoot;
        if($keyStoreFile and $keyStoreFile ne /^$/)
        {
            $command = $command." -Djavax.net.ssl.trustStore=".$keyStoreFile;
        }
        if($inputLength < 6)
        {
            #for oms 10205+
            $command = $command." -cp ".$classpath." ".$jboss_discovery_class." ".$jndiport." ".$jbosshost." ".$lib;
        }
        else
        {
            $command = $command." -cp ".$classpath." ".$jboss_discovery_class." ".$jndiport." ".$jbosshost." ".$lib." "."\"".$username."\""." "."\"".$password."\"";
        }
    }
    else
    {
        my $ports;
        #print "I am here";
        my $clientFolder = $installhome."/client";
        my $libFolder = $installhome."/lib";

        if (! -e $clientFolder."/jbossall-client.jar")
        {
            print "40";
            exit(0);
        }
        if (! -e $clientFolder."/jnp-client.jar")
        {
            print "40";
            exit(0);
        }
        if (! -e $clientFolder."/jboss-client.jar")
        {
            print "40";
            exit(0);
        }
        #if (! -e $installhome."/server/all/lib/jbosssx.jar")
        #{
        #    print "40";
        #    exit(0);
        #}
        if ($jndiport and $jndiport ne /^$/)
        {
            $ports = $jndiport;
        }
        else
        {
          chomp($os = $^O);
	  if (($os eq "MSWin32") || ($os eq "MSWin64")) 
	  {
	   	#$ports = "1099"; 
	   	my $jb_conf;
	   	my $jb_conf_file;
	   	my @file_lines;
                @all_commands = `nmefwmi wbem_classname=win32_process wbem_properties=CommandLine`;
                foreach $comm (@all_commands)
                {
                   if($comm =~ /org\.jboss\.Main/) {
                      my $i_conf;
                      my $sub_comm1;
                      my $sub_comm2;
                      my $i_conf2;
                         $i_conf = index($comm,' -c ');
                         if($i_conf eq -1) 
                         {
                            $jb_conf = "default";
                         }
                         else 
                         {
                            $sub_comm1 = substr($comm,$i_conf + 4);
                            $i_conf2 = index($sub_comm1,' ');
                              if ($i_conf2 eq -1) 
                              {
                                  $jb_conf = $sub_comm1;
                              }
                              else 
                              {
                                   $sub_comm2 = substr($sub_comm1,0,$i_conf2);
                                   $jb_conf = $sub_comm2;
                              }
                         }
                   }
                }
                  $jb_conf_file = $installhome."\/server\/".$jb_conf."\/conf\/jboss-service.xml";
                
                if(-e $jb_conf_file) 
                {
                   my $naming_tag;
                      $naming_tag = 0; #default naming tag is 0
                   open(INFO, $jb_conf_file);    
                   @file_lines = <INFO>;
                   close(INFO);
                       foreach $fline (@file_lines)
                          {
                   	    if($fline =~ /code=\"org\.jboss\.naming\.NamingService\"/)
                   	    {
                   	       $naming_tag = 1;
                   	    }
                   	    if( $naming_tag eq 1)
                   	    {
                   	         if($fline =~ /\<attribute name\=\"Port\"\>/)
                   	      	 {
				      my $port_index;
				      my $port_end_index;
				      my $sub_str1;
				      my $sub_str2;
					 $port_index = index($fline,'Port');
					 $sub_str1 = substr($fline,$port_index + 6);
					     $port_end_index = index($sub_str1,'</attribute>');
					 $sub_str2 = substr($sub_str1,0,$port_end_index);
					 $ports = $sub_str2;
                   	                 last;            
                   	      	 }
                   	    }
                   	    
                   	 }
                }
	   }
	   else {
            my %openPorts = getOpenPorts();
            #system("perl $emdRoot/emdw/sysman/admin/scripts/openports.pl > t");
            print %openPorts;

		    foreach $p (%openports)
		    {
			chomp($p);
			if ($p > 1023)
			{
			    $ports = $p.":".$ports;
			}
		    }
		    #print $ports;
           }
        }
        $classpath = getLocalClasspath($installhome);
        $command = $emdRoot."/jdk/bin/java -Doracle.home=".$emdRoot;
        $lib = $empty;
        if($keyStoreFile and $keyStoreFile ne /^$/)
        {
            $command = $command." -Djavax.net.ssl.trustStore=".$keyStoreFile;
        }            
        if($inputLength < 6)
        {
            #for oms 10205+
            $command = $command." -cp ".$classpath." ".$jboss_discovery_class." ".$ports." ".$jbosshost." ".$lib;
        }
        else
        {
            $command = $command." -cp ".$classpath." ".$jboss_discovery_class." ".$ports." ".$jbosshost." ".$lib." "."\"".$username."\""." "."\"".$password."\"";
        }
    }

    #print ERROR "command:$command*** \n";
    my $result =`$command`;
    #print "$result\n";
    print $result;
    #print $ports;

    sub trim 
    {
        my @out = @_;
        for (@out) 
        {
            s/^\s+//;
            s/\s+$//;
        }
        return wantarray ? @out : $out[0];
    }
    
    sub getRemoteClasspath
    {
        my $libpath = @_[0];
        #print $libpath."\n";
        my $classpath;
	    my $pathSep;
	    my $fileSep;
        chomp($os = $^O);
        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            $pathSep=":";
            $fileSep = "\/";
        }
        else
        {
	        $pathSep=";";
            $fileSep = "\\";
        }        
        #emConfigInstall.jar,log4j-core.jar and http_client.jar are needed to update classpath.lst
        $classpath= $emdRoot."/lib/xmlparserv2.jar".$pathSep.
                    $emdRoot."/jlib/emConfigInstall.jar".$pathSep.
                    $emdRoot."/sysman/jlib/log4j-core.jar".$pathSep.
                    $emdRoot."/modules/oracle.http_client_11.1.1.jar".$pathSep.                    
                    $libpath."/jbossall-client.jar".$pathSep.
                    $libpath."/jbosssx.jar".$pathSep.
                    $discovery_root."/archives/em-as-thirdparty-discovery.jar";

        return $classpath;
    }

    sub getLocalClasspath
    {
        my $libpath = @_[0];
        my $classpath;
	    my $pathSep;
	    my $fileSep;
        chomp($os = $^O);
        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            $pathSep=":";
            $fileSep = "\/";
        }
        else
        {
	        $pathSep=";";
            $fileSep = "\\";
        }        
        #emConfigInstall.jar,log4j-core.jar and http_client.jar are needed to update classpath.lst
        $classpath= $emdRoot."/lib/xmlparserv2.jar".$pathSep.
                    $emdRoot."/jlib/emConfigInstall.jar".$pathSep.
                    $emdRoot."/sysman/jlib/log4j-core.jar".$pathSep.
                    $emdRoot."/modules/oracle.http_client_11.1.1.jar".$pathSep.
                    $libpath."/client/jbossall-client.jar".$pathSep.
                    $installhome."/server/all/lib/jbosssx.jar".$pathSep.
                    $discovery_root."/archives/em-as-thirdparty-discovery.jar";

        return $classpath;
    }
    
    sub getOpenPorts()
    {
        $ENV{PATH} = "$ENV{PATH}:/usr/bin:/usr/sbin:/usr/ucb:/bin";
        chomp($os = $^O);
        if (($os ne "MSWin32") && ($os ne "MSWin64")) 
        {
            chomp($os = `uname -s`);
        }
        @NETSTAT = `netstat -an `;
        LINE: for $userline (@NETSTAT) 
        {
            #print $userline;
            if (index($userline, "127.0.0.1") >= 0) { next LINE; }


            if (index($userline, "LISTEN") < 0 && index($userline, "IDLE") < 0) { 
                next LINE; 
            }
            # for unix  domain sockets $userline has LISTENING, skip those lines
            if ($os eq "Linux" && index($userline, "LISTENING") >= 0) { 
                next LINE; 
            }
           
            #only considering tcp ports
            #if (index($userline, "tcp") < 0 && index($userline, "TCP") < 0 ) { 
            #    next LINE;
            #}
            
            #print "being processed...";
			#	print "NETSTAT: $userline\n";

            # $userline looks like on solaris:
            #	*.*                  *.*                0      0 24576      0 IDLE
            #	*.7000               *.*                0      0 24576      0 LISTEN
            #	*.3201               *.*                0      0 24576      0 LISTEN
            #	130.35.38.158.3101   *.*                0      0 24576      0 LISTEN
            #	*.*                  *.*                0      0 24576      0 IDLE
            # $userline looks like on windows:
            #	(udp|tcp) [0-9\.]*:port                  *.*                IDLE

            @points = split(/[\t\ ]+/, $userline);

            # window windows there is a : in the  line
            if (index($userline, ":") > 0) 
            {
                if ($os eq "Linux") {
                    $p1 = $points[3];
                } else {
                    $p1 = $points[2];  # windows
                }
                @point = split(/:/, $p1);
                $p = $point[$#point];	# last item within <numeric ip>:<port number>, i.e. port
                $openports{$p} += 1;	# add <port> as a key to the lookup table
            } 
            else 
            {
                if ($os eq "HP-UX" || $os eq "OSF1" || $os eq "AIX") {
                    $p1 = $points[3];
                } else {
                    $i = index($userline, " ");
                    if ($i > 0)
                    {
                        $p1 = $points[0];
                    }
                    else
                    {
                        $p1 = $points[1];
                    }
                }
				#    print "NETSTAT[1] : $i \"$p1\" of \"$userline\"\n";
                if ($p1 ne "*\.*")
                {
                    @point = split(/\.+/, $p1);
                    $pl = @point;
                    $p = $point[$pl - 1];	# last item within <numeric ip>.<port number>, i.e. port
                    $openports{$p} += 1;	# add <port> as a key to the lookup table
                }
            }
        }
        return @openports;
    }       
}
