#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/mdaagentoper.pl /main/9 2012/06/10 20:53:57 rahs Exp $
#
# mdaagentoper.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      mdaagentoper.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rahs        06/05/12 - Adding extra parameters.
#    rahs        04/11/12 - Bug 13844234
#    spandita    02/27/12 - XbranchMerge spandita_bug-13769357 from
#                           st_emgc_12.1.0.1bp12.1.0.2pg
#    spandita    02/24/12 - 13769357
#    ckannusa    06/23/11 - Remove wlfull client dependecny
#    ckannusa    05/24/11 - Changes to support remote agent
#    ckannusa    04/29/11 - Use PLUGIN_ROOT instead of ORACLE_HOME
#    ckannusa    12/14/10 - Remove communication with admin server -
#                           12GCBETATWO
#    ckannusa    10/26/10 - Include Frequency
#    ckannusa    05/19/10 - Creation
#    ckannusa    05/19/10 - Creation
# 
use strict;
use File::Spec::Functions;


use IPC::Open2;
use ParseStdin;

require "semd_common.pl";
require "emd_common.pl";
my $LEVEL_DEBUG  = 10;
my $LEVEL_INFO   = 20;
my $LEVEL_WARN   = 30;
my $LEVEL_ERROR  = 40;
my $trace_level = $ENV{EMAGENT_PERL_TRACE_LEVEL};

_debug("******* In: mdaagentoper.pl", $LEVEL_DEBUG);

my $WLST_SH ="wlst.sh";
my $inputString=@ARGV[0];
my($targetName,$wlTargetTypes,$frequency,$jmxServiceURL,$operName,$eff,$ineff,$disableDcFor) =  split("#", $inputString);
_debug("Inputs:".$targetName." ".$wlTargetTypes." ".$frequency." ".$jmxServiceURL." ".$operName." ".$eff." ".$ineff, $LEVEL_DEBUG);
my $agentInstHome = $ENV{EMSTATE};
my $oraHome = $ENV{ORACLE_HOME};

my $trustStore =  catfile($agentInstHome,'sysman','config','montrust','AgentTrust.jks');
_debug("Agent trust store path :".$trustStore, $LEVEL_DEBUG);
my $AGENT_PLUGIN_ROOT = $ENV{'PLUGIN_ROOT'};
my $java = catfile($oraHome, 'jdk', 'bin', 'java');
my $wlcipherjar = catfile($AGENT_PLUGIN_ROOT, 'archives','jlib', 'wlcipher.jar');
my $wlfullclientjar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib','wlfullclient.jar');
my $wlthint3client = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib','wlthint3client.jar');
#my $wlthint3client = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'wljmxclient.jar');
my $mdajmxutil =  catfile($AGENT_PLUGIN_ROOT,'archives','mda', 'mdajmxutil.jar');
my $classpath;
my $exeScript;
my $cpsep = ":";
if(&IsWindows() ) {
        $cpsep = ";";
}
if($targetName eq '')
{
        print "<result>STATUS=FAIL|CODE=MDA_TARGET_NAME_UNAVAILABLE|Input Validation failure|Target name not available</result>";
        exit(1); 
}
elsif ($wlTargetTypes eq '')
{
        print "<result>STATUS=FAIL|CODE=MDA_TARGET_TYPE_UNAVAILABLE|Input Validation failure|Target type not available</result>";
        exit(1);
}
elsif($frequency eq '')
{
        print "<result>STATUS=FAIL|CODE=MDA_FREQUENCY_UNAVAILABLE|Input Validation failure|Frequency not available</result>";
        exit(1);
}
elsif($jmxServiceURL eq '')
{
        print "<result>STATUS=FAIL|CODE=MDA_JMX_SERVICE_UNAVAILABLE|Input Validation failure|JMX service URL not available</result>";
        exit(1);
}
elsif($operName eq '')
{
        print "<result>STATUS=FAIL|CODE=MDA_OPERATION_NAME_UNAVAILABLE|Input Validation failure|Operation name not available</result>";
        exit(1);
}
elsif($eff eq '')
{
        print "<result>STATUS=FAIL|CODE=MDA_EFFICIENCY_UNAVAILABLE|Input Validation failure|Efficiency not available</result>";
        exit(1);
}
elsif($ineff eq '')
{
        print "<result>STATUS=FAIL|CODE=MDA_INEFFICIENCY_UNAVAILABLE|Input Validation failure|Inefficiency not available</result>";
        exit(1);
}
elsif (!( -e $trustStore))
{
        print "<result>STATUS=FAIL|CODE=MDA_TRUST_STORE_UNAVAILABLE|Input Validation failure|Trust store not available</result>";
        exit(1);
}

if ($operName eq "ENABLE")
{
        $operName = "enable";
}
elsif ($operName eq "DISABLE")
{
        $operName = "disable";
}
my $args = $targetName." ". $frequency." ".$eff." ".$ineff." ".$wlTargetTypes." ".$jmxServiceURL." ".$operName." ".$disableDcFor;
if( ($jmxServiceURL =~ m/t3s/) || ($jmxServiceURL =~ m/iiops/))
{
	_debug("Branch t3s or iiops", $LEVEL_DEBUG);
	if((-r  $wlfullclientjar) && (-r $wlcipherjar))
	{
		$classpath = $wlfullclientjar.$cpsep.$wlcipherjar.$cpsep.$mdajmxutil.$cpsep;
        	_debug("Branch t3s or iiops - wlfullclient and wlcipher are present :classpath - ".$classpath, $LEVEL_DEBUG);
	        $exeScript  = $java." "."-Dweblogic.security.SSL.ignoreHostnameVerify=true -Dweblogic.security.SSL.enforceConstraints=off -Dweblogic.security.SSL.trustedCAKeyStore=".$trustStore." "."-cp"." ".$classpath." "." oracle.sysman.emas.mda.jmxutil.MDAJMXConnector"." ".$args;
        	_debug("Branch t3s or iiops - wlfullclient and wlcipher are present :exescript - ".$exeScript, $LEVEL_DEBUG);

	}
	else
	{
		$classpath =  $wlthint3client.$cpsep.$mdajmxutil.$cpsep;
	        _debug("Branch t3s or iiops -  No wlfullclient and wlcipher jars :classpath - ".$classpath, $LEVEL_DEBUG);
        	$exeScript  = $java." "."-Dweblogic.security.SSL.ignoreHostnameVerify=true -Dweblogic.security.SSL.enforceConstraints=off  -Djavax.net.ssl.trustStore=".$trustStore." "."-cp"." ".$classpath." "." oracle.sysman.emas.mda.jmxutil.MDAJMXConnector"." ".$args;
	        _debug("Branch t3s or iiops  No wlfullclient and wlcipher jars :exescript - ".$exeScript, $LEVEL_DEBUG);

	}
}
else
{
         $classpath = $wlthint3client.$cpsep.$mdajmxutil.$cpsep;
	 _debug("Non Secured classpath - ".$classpath, $LEVEL_DEBUG);
         $exeScript  = $java." "."-cp"." ".$classpath." "." oracle.sysman.emas.mda.jmxutil.MDAJMXConnector"." ".$args;
	 _debug("Non Secured exescript - ".$exeScript, $LEVEL_DEBUG);
}

#java -Dweblogic.security.SSL.ignoreHostnameVerify=true -Dweblogic.security.SSL.trustedCAKeyStore=AgentTrust.jks -Dssl.debug=true -cp .:wlfullclient.jar:webserviceclient+ssl.jar MDAJMXConnector

print "Command to Execute : ".$exeScript;
my $resultStr = `$exeScript`;
print $resultStr;

if ($resultStr =~ /STATUS=SUCCESS/)
{
	 _debug("Java cmd succeeded", $LEVEL_DEBUG);
        exit(0);
}
elsif ($resultStr =~ /STATUS=FAIL/)
{
	 _debug("Java cmd failure", $LEVEL_DEBUG);
        exit(1);
}
else
{
	 _debug("No success or failure - java cmd not executed  - ".$classpath, $LEVEL_ERROR);
        print "<result>STATUS=FAIL|Could not execute java command|Please verify classpath</result>";
        exit(1);
}
#Procedure to check OS 
sub IsWindows {
    my $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}
sub _debug
{   
  my($strToPrint, $trace_level) = @_;
  EMD_PERL_DEBUG($strToPrint);

}
