#mdaagentoper.py
#=======================================================================================
 
#=======================================================================================
# This script is to Query different status and attribute of MDA application hosting the Data Collection module.
# How to use this Script 
# Usage: 
#       wlst mdaagentoper.py <AdminServerHost> <Admin Server Port> <Domain User> <Domain Pwd>
#                                <WLTargetManagedServer as seen in console> 
#                                <WLTargetManagedServerHost> <WLTargetManagedServerPort>
#                               <ApplicationName> <OperationName>
#=======================================================================================

#=======================================================================================
# Failure Scenarios handled 
# STATUS=FAIL|CONNECT EXP|exception
# STATUS=FAIL|COULD NOT FIND STATUS|unknow exception
# STATUS=FAIL|MBEAN ACCESS EXP|exception
# STATUS=FAIL|INVALID OPERATION
# 
# STATUS=SUCCESS - When the operation is successful
# 
# Failed Results are tagged as <result>Status|reason|exception string</result>'
# Failed Results are tagged as <result>Status|operationaname|return value is any</result>'
#======================================================================================= 



#=======================================================================================
# Function to Find the Application status.This scripts assumes None and STATE_NEW state
# assumed as app not deployed yet .Need to test other status
# Other status documented in AppRuntimeStateRuntimeMBean are 
#       STATE_ACTIVE    Ruuning and available
#       STATE_ADMIN     Running but only accessible through admin port
#       STATE_FAILED    Configured but not deployed.
#       STATE_NEW       Configured but not deployed.
#       STATE_PREPARED  Ready for activation
#       STATE_RETIRED   Configured but not deployed.
#       STATE_UPDATE_PENDING Running and being updated
#=======================================================================================
from java.io import *
def dcAppStatus(appName, serverName):
     cd('domainRuntime:/AppRuntimeStateRuntime/AppRuntimeStateRuntime')
     #get current real state for app in specific server
     currentState = cmo.getCurrentState(appName, serverName)
     print appName      
     return currentState


#=======================================================================================
# Function to enable DC operation of the Runtime MBean
#=======================================================================================
def enableDC(serverName,status):
        print 'calling enable dc ' 
        objName ='mda:ServerRuntime='+serverName+',Name=mdaMBean,Location='+serverName+',Type=MDADataCollectorRuntimeMBean'
        print 'MBean Object Name' + objName
	#Comment the navigation now , it is done already during set Model Types
        #custom()
	#cd('mda')
        #cd(objName)
        objs = jarray.array([],java.lang.Object)
        strs = jarray.array([],java.lang.String)
        print(invoke(status,objs,strs)) 
        print "enabled now ......."
        return

#=======================================================================================
#Function to set Model Types 
#=======================================================================================
def setModelTypes(serverName,targetTypes,effThreshold,inEffThreshold):
        print 'calling set Model Types in  dc runtime mbean '
        objName ='mda:ServerRuntime='+serverName+',Name=mdaMBean,Location='+serverName+',Type=MDADataCollectorRuntimeMBean'
        print 'MBean Object Name' + objName
        custom()
        print 'inside custom'
        cd('mda')
        print 'inside mda'
        cd(objName)
        print 'parsed mbean tree...'
        zyArray=targetTypes.split('|')
        # stringArray = jarray.array(ary,java.lang.String)
        print 'List of Target Types ',zyArray
        # objs = jarray.array([jarray.array(zyArray,java.lang.String)],java.lang.Object)
        # objs = jarray.array([stringArray],java.lang.Object)
        #strs = jarray.array(['[Ljava.lang.String;'],java.lang.String)
        print 'set MBean attribute ModelTypes..'
        #invoke("setModelTypes",objs,strs)
	set('ModelTypes',jarray.array(zyArray,java.lang.String));
	set('ModelEfficiencyThreshold',effThreshold)
	set('ModelInEfficiencyThreshold',inEffThreshold)
	print 'collection interval ' ,frequency
	set('CollectionInterval',int(frequency))
        print "invoke oper done!"
        return


#=======================================================================================
# Function to read Attributes from the MDA DAta Collector Mbean
#=======================================================================================

def getAttribute(serverName,attribute):        
        objName ='mda:ServerRuntime='+serverName+',Name=mdaMBean,Location='+serverName+',Type=MDADataCollectorRuntimeMBean'
        print 'MBean Object Name' + objName
        custom()
        cd('mda')
        cd(objName)
        objs = jarray.array([],java.lang.Object)
        strs = jarray.array([],java.lang.String)
        print "getting version......"
        attrValue = get(attribute) 
        print "got version......"+attrValue
        return attrValue


#adminHost = sys.argv[1]  # Admin Server Host
#adminPort = sys.argv[2] # Admin Server Port


targetWLS = sys.argv[1] # Weblogic Managed Server Name
targetWLSHost = sys.argv[2] # Weblogic Managed Server Host
targetWLSPort = sys.argv[3] # Weblogic Managed Server Port

appName = sys.argv[4] # Application Name
wlTargetTypes = sys.argv[5] #'|' delimited target types
effThreshold =  0.33
inEffThreshold = 0.66
frequency = sys.argv[6] 
operName  = sys.argv[7] # Operation Name

#Get the username and passowrd through input stream
#Need to confirm if any more vulnerabilities are there

input = BufferedReader(InputStreamReader(System.in))
inputStr=input.readLine()
inputList = inputStr.split('|')
domainUser= inputList[0]
domainPwd = inputList[1]
#TO-DO Need to connect using t3s,will revisit this again
#adminHostdminConnectStr = "t3://"+adminHost+":"+adminPort
wlsMSConnectStr= "t3://"+targetWLSHost+":"+targetWLSPort


if operName == 'ENABLE':
        try:
                print 'In ENABLE - Connecting server '
                connect(domainUser,domainPwd,wlsMSConnectStr)
                print 'connection success'

        except(Exception), e:
                print '<result>STATUS=FAIL|CONNECT EXP|',e,'</result>' 
                exit(exitcode=1)
        try:
                print 'connecte 111111'
		setModelTypes(targetWLS,wlTargetTypes,effThreshold,inEffThreshold)
                enableDC(targetWLS,'enable')
		
                print '<result>STATUS=SUCCESS|ENABLE','</result>' 
        except(Exception), e:
                print '<result>STATUS=FAIL|MBEAN ACCESS EXP|',e,'</result>' 
elif operName == 'DISABLE':
        try:
                print 'In DISABLE - Connecting server '
                connect(domainUser,domainPwd,wlsMSConnectStr)
        except(Exception), e:
                print '<result>STATUS=FAIL|CONNECT EXP|',e,'</result>' 
                exit(exitcode=1)
        try:
		setModelTypes(targetWLS,wlTargetTypes,effThreshold,inEffThreshold)
                enableDC(targetWLS,'disable')
                print '<result>STATUS=SUCCESS|DISABLE','</result>' 
                exit (exitcode=0)
        except(Exception), e:
                print '<result>STATUS=FAIL|MBEAN ACCESS EXP|',e,'</result>' 
                exit(exitcode=1)
elif operName == 'GETVERSION':
        try:
                print 'In GETVERSION - Connecting Server '
                connect(domainUser,domainPwd,wlsMSConnectStr)
        except(Exception), e:
                print '<result>STATUS=FAIL|CONNECT EXP|',e,'</result>' 
                exit(exitcode=1)
        try:
                version = getAttribute(targetWLS,'Version')
                print '<result>STATUS=SUCCESS|GETVERSION|',version,'</result>' 
                exit (exitcode=0)
        except(Exception), e:
                print '<result>STATUS=FAIL|MBEAN ACCESS EXP|',e,'</result>' 
                exit(exitcode=1)

elif operName == 'SETMODELTYPES':
        try:
                print 'In SETMODELTYPES - Connecting Server '
                connect(domainUser,domainPwd,wlsMSConnectStr)
        except(Exception), e:
                print '<result>STATUS=FAIL|CONNECT EXP|',e,'</result>'
                exit(exitcode=1)
        try:
                setModelTypes(targetWLS,wlTargetTypes)
                print '<result>STATUS=SUCCESS|SETMODELTYPES|','</result>'
                exit (exitcode=0)
        except(Exception), e:
                print '<result>STATUS=FAIL|MBEAN ACCESS EXP|',e,'</result>'
                exit(exitcode=1)

# elif operName == 'ISDEPLOYED':
                # This is different from the above calls 
                # Need to connect to admin server instead of the managed server directly
#        try:
#                print 'In ISDEPLOYED - Connecting Server '
#                connect(domainUser,domainPwd,adminConnectStr)
#        except(Exception), e:
#                print '<result>STATUS=FAIL|CONNECT EXP|',e,'</result>' 
#                exit(exitcode=1)
#        try:
#                status =  dcAppStatus(appName,targetWLS)
#                print '<result>STATUS=SUCCESS|GOTSTATUS|',status,'</result>' 
#        except(Exception), e:
#                print '<result>STATUS=FAIL|COULD NOT FIND STATUS|',e,'</result>'
#                exit(exitcode=1)

else:
        print '<result>STATUS=FAIL|INVALID OPERATION','</result>'
        exit(exitcode=1)
